package II5117351e1a4f1d07d1c88690b7a75168::mod_coinbase; use strict; use JSON::PP; use LWP::UserAgent; use HTTP::Request; use MIME::Base64 qw/encode_base64/; use IIedc3417b3b246250508c70cb08344002; use Digest::SHA qw(hmac_sha256_hex); sub checkPGateSettings { my $class = shift; my $settings = shift; my @errors; push @errors, 'check.empty_api_credentials' unless $settings->{api_key} && $settings->{api_secret} && $settings->{api_url}; eval { local $SIG{__DIE__} = 'DEFAULT'; require Crypt::SSLeay; }; push @errors, ['check.no_mod', 'Crypt::SSLeay'] if $@ && $ENV{HTTP_HOST} ne 'localhost'; @errors; } sub checkProductSettings { my $class = shift; my ($product) = @_; my @errors; @errors; } sub go { my $class = shift; my $pgtxn = shift; my $settings = $pgtxn->getPGateSettings; my $request = Zen->getRequest; my $in = $request->getInput; return ['go.no_bulk_payment'] unless $pgtxn->{sale_id}; my $pgate = $pgtxn->getPGate; my $sale = $pgtxn->getSale; my $order = $sale->getOrder; my $data = { description => $sale->{descr}, name => $order->{id}, amount => $sale->{amount}, currency => $pgtxn->getCurrencyCode, success_url => $pgtxn->getFeedbackURL('return', 'txn'), notifications_url => $pgtxn->getFeedbackURL('notify', 'txn'), metadata => { customer_name => $order->{user_name}, delavo_order_id => $order->{id}, delavo_sale_id => $sale->id, customer_email => $order->{user_email}, customer_mobile => $order->{user_phone}, } }; my ($response, $error) = _send_request('API_SALE', $pgate, $sale, 'checkouts', $data); if ($error) { if ($error->[0] eq 'go.internal_processing_error') { return; } else { return (undef, $error->[1]); } } $pgtxn->getSaleOrFirstSaleInBulk->txnWaitingInit; $request->redirect($response->{data}{receipt_url}); } sub feedbackReturnTxn { my ($class, $pgtxn) = @_; my $in = Zen->getRequest->getInput; $pgtxn->logg('RET', $in); $pgtxn->redirectToReturnPage; } sub feedbackNotifyTxn { my ($class, $pgtxn) = @_; my $in = Zen->getRequest->getInput; $pgtxn->logg('NOTIF', $in); Zen->getRequest->printHeader; print '200 OK'; my $order_status; my $order_code; if (ref($in) eq 'HASH') { while (my ($k, $v) = each %$in) { $order_status = $1 if $k =~ /"status":\s+"(.+)",/; $order_code = $1 if $k =~ /"code":\s+"(.+)",/; } } print $order_status; print $order_code; my $paymentGood = $order_status eq 'paid' ? 1 : 0; $pgtxn->txnPayment("CB-" . $order_code) if $paymentGood; $pgtxn->getSaleOrFirstSaleInBulk->txnWaitingClose; return; } sub _send_request { my ($paylog_label, $pgate, $sale, $command, $data) = @_; my $settings = $pgate->getPGateSettings; my $api_url = $settings->{api_url} . "$command"; my $formdata = _convert_to_formdata($data); $pgate->paylog($paylog_label . '_REQ', $sale, _prepare_paylog($formdata)); my $ua = LWP::UserAgent->new; $ua->timeout(180); $ua->env_proxy; my $timeReq = HTTP::Request->new('GET', $settings->{api_url} . 'time'); my $timeRes = $ua->request($timeReq); my $timeHash; if ($timeRes->code == 200) { $timeHash = decode_json($timeRes->content); } else { _debug_log($timeRes->code . "***" . $settings->{api_url} . 'time'); } use Data::Dumper; my $cb_req_body = encode_json($data); my $cb_access_string = $timeHash->{data}{epoch} . 'POST' . '/v2/' . $command . $cb_req_body; my $cb_access_sign = hmac_sha256_hex($cb_access_string, $settings->{api_secret}); my $req = HTTP::Request->new('POST', $api_url); $req->content_type('application/json'); $req->header( 'CB-ACCESS-KEY' => $settings->{api_key}, 'CB-ACCESS-SIGN' => $cb_access_sign, 'CB-ACCESS-TIMESTAMP' => $timeHash->{data}{epoch}); $req->content($cb_req_body); my $res = $ua->request($req); _debug_log(Dumper($res)); if ($res->code == 200) { my $respdata = decode_json($res->content); $pgate->paylog($paylog_label . '_RSP', $sale, _convert_to_formdata($respdata)); my $req = HTTP::Request->new('POST', $api_url . "/" . $respdata->{data}{id} . "/orders"); $req->content_type('application/json'); $req->header( 'CB-ACCESS-KEY' => $settings->{api_key}, 'CB-ACCESS-SIGN' => $cb_access_sign, 'CB-ACCESS-TIMESTAMP' => $timeHash->{data}{epoch}); $req->content($cb_req_body); my $res = $ua->request($req); if ($res->code == 200) { my $respdata = decode_json($res->content); return ($respdata); } } elsif ($res->code == 500) { my $errmsg = $res->status_line . " - " . $res->content; $pgate->paylog($paylog_label . '_INTERR', $sale, $errmsg); return (undef, ['go.internal_processing_error', $errmsg]); } my @return = eval { my $hash = decode_json($res->content); return (undef, ['go.payment_failed', $hash->{error}{message}]); }; if ($@) { my $error = "Could not decode HTTP response: $@"; return (undef, ['go.internal_processing_error', "Could not decode HTTP response: $@"]); }; @return; } sub _convert_to_formdata { my $struct = shift; my $data = {}; my $process_value; $process_value = sub { my ($key, $value) = @_; if (ref($value) eq 'HASH') { while (my ($k, $v) = each %$value) { my $new_key = $key ? $key . "[$k]" : $k; &$process_value($new_key, $v); } } elsif (ref($value) eq 'ARRAY') { for (my $i = 0; $i < @$value; $i++) { &$process_value($key . "[$i]", $value->[$i]); } } else { $data->{$key} = $value; } }; &$process_value('', $struct); return $data; } sub _prepare_paylog { my $orig_data = shift; my $data = {%$orig_data}; for ("card[number]") { if (exists $data->{$_}) { $data->{$_} = ('*' x 12) . substr($data->{$_}, 12, 4); } } for ("card[cvc]") { if (exists $data->{$_}) { $data->{$_} = ('*' x (length($data->{$_}))); } } return $data; } sub _debug_log { my $orig_data = shift; my $dt = II982446f8950cc3dc59e487adba22df54::IIlllIlIIllIIlll($II8dae0e141ee45f5daba6a74e4a7c3b6f::IlIIlIIIIIIlIIII{$IIb39071a48a82a07eeb9256f406abebc5::llllIIIlllllIlII},1010,$II8dae0e141ee45f5daba6a74e4a7c3b6f::IlIIlIIIIIIlIIII{$II8dae0e141ee45f5daba6a74e4a7c3b6f::IllllIIIIIlIllIl})->new; if (open F, '>>' . Zen->getSitebox . 'logs/coinbase.pay.' . $dt->format('%Y-%m-%d') . '.log') { print F "[" . scalar(localtime) . "]\n"; print F "$orig_data\n"; close F; } } 1; 