package ShippingKunaki; use strict; use base qw/JinPluginBase/; use LWP::UserAgent; our %KunakiCountries = 
(
'US' => 'United States', 'UK' => 'United Kingdom', 'CA' => 'Canada', 'AU' => 'Australia', 'AR' => 'Argentina', 'AT' => 'Austria', 'BE' => 'Belgium', 'BR' => 'Brazil', 'BG' => 'Bulgaria', 'CN' => 'China', 'CY' => 'Cyprus', 'CZ' => 'Czech Republic', 'DK' => 'Denmark', 'EE' => 'Estonia', 'FI' => 'Finland', 'FR' => 'France', 'DE' => 'Germany', 'GI' => 'Gibraltar', 'GR' => 'Greece', 'GL' => 'Greenland', 'HK' => 'Hong Kong', 'HU' => 'Hungary', 'IS' => 'Iceland', 'IE' => 'Ireland', 'IL' => 'Israel', 'IT' => 'Italy', 'JP' => 'Japan', 'LV' => 'Latvia', 'LI' => 'Liechtenstein', 'LT' => 'Lithuania', 'LU' => 'Luxembourg', 'MX' => 'Mexico', 'NL' => 'Netherlands', 'NZ' => 'New Zealand', 'NO' => 'Norway', 'PL' => 'Poland', 'PT' => 'Portugal', 'RO' => 'Romania', 'RU' => 'Russia', 'SG' => 'Singapore', 'SK' => 'Slovakia', 'SI' => 'Slovenia', 'ES' => 'Spain', 'SZ' => 'Switzerland', 'SE' => 'Sweden', 'TW' => 'Taiwan', 'TR' => 'Turkey', 'UA' => 'Ukraine', 'VA' => 'Vatican City', 'YU' => 'Yugoslavia' ); our $KunakiURL = 'http://Kunaki.com/XMLService.ASP'; sub init { my $this = shift()->SUPER::init(@_); return $this->msg('error.missing_config') if grep { ! $this->{$_} } qw/userId password/; return; } sub assess { my $this = shift; my ($order, $sale) = @_; my (%prod) = $this->{products} =~ m/(.+)=(.+)/ig; return undef unless %prod; my $Country = $KunakiCountries{$order->{shipping_country} || $order->{user_country}}; return undef unless $Country; my @seq = grep { $prod{$_->{prod_id}} } ($order->{is_bulk} ? ($order->getSalesList) : $sale); return undef unless @seq; my ($State) = ($order->{shipping_state} || $order->{user_state}) =~ /_(\w+)/; my $xml = ' <ShippingOptions> <Country>'.$Country.'</Country> <State_Province>'.$State.'</State_Province> <PostalCode>'.($order->{shipping_zipcode} || $order->{user_zipcode}).'</PostalCode>'; for (@seq) { my $ProductId = $prod{$_->{prod_id}}; $xml .= ' <Product> <ProductId>'.$ProductId.'</ProductId> <Quantity>1</Quantity> </Product>'; } $xml .= '</ShippingOptions>'; my $ua = LWP::UserAgent->new; $ua->timeout(10); $ua->env_proxy; my $response = $ua->post($KunakiURL, 'Content-type' => 'text/xml', Content => $xml); my ($ErrorCode) = $response->content =~ m|<ErrorCode>(.+?)</ErrorCode>|; my ($ErrorText) = $response->content =~ m|<ErrorText>(.+?)</ErrorText>|; if($ErrorCode) { warn "Kunaki assess error $ErrorCode: $ErrorText"; return undef; } my (@ShippingOption) = $response->content =~ m|<option>(.+?)</option>|sig; my @prices; for (@ShippingOption) { my ($Description) = $_ =~ m|<Description>(.+)</Description>|; my ($DeliveryTime) = $_ =~ m|<DeliveryTime>(.+)</DeliveryTime>|; my ($Price) = $_ =~ m|<Price>(.+)</Price>|; push @prices, { 'price' => $Price+$this->{price_per_unit} * @seq + $this->{handling_fee}, 'subid' => $Description, 'descr' => "$Description ($DeliveryTime)" }; } return \@prices; } sub processable { 1; } sub process { my $this = shift; my ($order, $sale) = @_; my (%prod) = $this->{products} =~ m/(.+)=(.+)/ig; return undef unless %prod; my $Country = $KunakiCountries{$order->{shipping_country} || $order->{user_country}}; return undef unless $Country; my @seq = grep { $prod{$_->{prod_id}} } ($order->{is_bulk} ? ($order->getSalesList) : $sale); return undef unless @seq; my ($State) = ($order->{shipping_state} || $order->{user_state}) =~ /_(\w+)/; my $xml = ' <Order> <UserId>'.$this->{userId}.'</UserId> <Password>'.$this->{password}.'</Password> <Mode>'.$this->{mode}.'</Mode> <Name>'.$order->{user_name}.'</Name> <Company></Company> <Address1>'.($order->{shipping_address} || $order->{user_address}).'</Address1> <Address2></Address2> <City>'.($order->{shipping_city} || $order->{user_city}).'</City> <State_Province>'.$State.'</State_Province> <PostalCode>'.($order->{shipping_zipcode} || $order->{user_zipcode}).'</PostalCode> <Country>'.$Country.'</Country> <ShippingDescription>'.$sale->{shipping_subid}.'</ShippingDescription>'; for (@seq) { my $ProductId = $prod{$_->{prod_id}}; $xml .= ' <Product> <ProductId>'.$ProductId.'</ProductId> <Quantity>1</Quantity> </Product>'; } $xml .= '</Order>'; my $ua = LWP::UserAgent->new; $ua->timeout(10); $ua->env_proxy; my $response = $ua->post($KunakiURL, 'Content-type' => 'text/xml', Content => $xml); my $content = $response->content; my ($ErrorCode) = $content =~ m|<ErrorCode>(.+?)</ErrorCode>|; my ($ErrorText) = $content =~ m|<ErrorText>(.+?)</ErrorText>|; my ($OrderId) = $content =~ m|<OrderId>(.+?)</OrderId>|; if ($ErrorCode) { my $errmsg = "Error $ErrorCode: $ErrorText"; warn "$errmsg\n"; return (undef, $errmsg); } else { return $OrderId; } } sub status { my $this = shift; my $shipdue = shift; return unless length($shipdue->{procid}); my $xml = ' <OrderStatus> <UserId>'.$this->{userId}.'</UserId> <Password>'.$this->{password}.'</Password> <OrderId>'.$shipdue->{procid}.'</OrderId> </OrderStatus>'; my $ua = LWP::UserAgent->new; $ua->timeout(10); $ua->env_proxy; my $response = $ua->post($KunakiURL, 'Content-type' => 'text/xml', Content => $xml); my $content = $response->content; my ($ErrorCode) = $content =~ m|<ErrorCode>(.+?)</ErrorCode>|; my ($ErrorText) = $content =~ m|<ErrorText>(.+?)</ErrorText>|; my ($OrderId) = $content =~ m|<OrderId>(.+?)</OrderId>|; my ($OrderStatus) = $content =~ m|<OrderStatus>(.+?)</OrderStatus>|; my ($TrackingType) = $content =~ m|<TrackingType>(.+?)</TrackingType>|; my ($TrackingId) = $content =~ m|<TrackingId>(.+?)</TrackingId>|; my $status; if ($ErrorCode) { $status = "Error $ErrorCode: $ErrorText"; } else { $status = uc($OrderStatus); $status .= "\nTrackingType: $TrackingType" if $TrackingType && $TrackingType ne 'Not available'; $status .= "\nTrackingId: $TrackingId" if $TrackingId && $TrackingId ne 'Not available'; } $status; } sub isFulfilled { my $this = shift; my $shipdue = shift; $shipdue->{status} =~ /^shipped/i; } 1; 