create table jin_cmsmem
(
  id int(11) not null primary key,
  owner_id int(11) not null,

  ext_script int(11) not null default 0,
  path varchar(255) not null,

  key(owner_id)
);

create table jin_user_cmsmem
(
  id int(11) not null primary key,
  owner_id int(11) not null,

  sale_id int(11) not null default 0,
  user_id int(11) not null default 0,

  cmsmem_id int(11) not null,

  expires date null,

  key(owner_id,user_id),
  key(owner_id,sale_id),
  key(owner_id,cmsmem_id)
);

alter table jin_role add priv_master_store_cmsmems int(1) not null default 0 after priv_master_store_rmems;

alter table jin_role add priv_master_customers_cmsmems int(1) not null default 0 after priv_master_customers_rmems;

alter table jin_product add dlv_cmsmems varchar(255) not null default '' after dlv_rmems;

alter table jin_embedded_email add access_cmsmem text not null default '' after access_rmem;

create table jin_quest
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,

  title          varchar(255) not null default '',
  instructions   text not null default '',

  notify_emails  varchar(255) not null default '',
  notify_create  text not null default '',
  notify_delete  text not null default '',

  trigger_url    varchar(255) not null default '',
  trigger_secret varchar(255) not null default '',
  trigger_method varchar(10) not null default '',

  key(owner_id)
);

create table jin_quest_item
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,

  quest_id    int(11) not null,

  title       varchar(255) not null default '',
  mandatory   int(1) not null default 0,
  type        varchar(30) not null default '',
  customlist  text not null default '',

  qsfield     varchar(50) not null default '',
  
  key(owner_id,quest_id)
);

create table jin_user_quest
(
  id           int(11) not null primary key,
  owner_id     int(11) not null,

  sale_id      int(11) not null default 0,
  user_id      int(11) not null default 0,

  quest_id     int(11) not null,

  expires      date null,

  userinput    text not null default '',
  triggertext  text not null default '',

  key(owner_id,user_id),
  key(owner_id,sale_id),
  key(owner_id,quest_id)
);

alter table jin_role add priv_master_store_quests int(1) not null default 0 after priv_master_store_cmsmems;

alter table jin_product add dlv_quests varchar(255) not null default '' after dlv_resprogs;

alter table jin_role add priv_master_customers_quests int(1) not null default 0 after priv_master_customers_cmsmems;

alter table jin_role add limit_minisites varchar(50) not null default '' after limit_packages;
alter table jin_role add limit_shopcarts varchar(50) not null default '' after limit_minisites;

alter table jin_order modify sequence text not null default '';
