
create table jin_shipping
(
  id           int(11) not null primary key,
  owner_id     int(11) not null,

  type         varchar(50) not null default '',
  
  title        varchar(50) not null default '',
  settings     text not null default '',
  
  email_status text not null default ''
);

alter table jin_role add priv_master_store_shippings int(1) not null default 0 after priv_master_store_taxes;
alter table jin_package add shipping int(1) not null default 0 after html_head;


alter table jin_sale add shipping_id int(11) not null default 0 after points_earned;
alter table jin_sale add shipping_price varchar(50) not null default '' after shipping_id;

# "bulk payment in minisites" problem DB fix
update jin_package set pgates='' where type=1;


alter table jin_sale add tax varchar(50) not null after amount;
alter table jin_sale add amount_prod varchar(50) not null default '' after amount;
alter table jin_sale add amount_discount varchar(50) not null default '' after amount_prod;
alter table jin_sale change tax amount_tax_pc varchar(50) not null default '' after amount_discount;
alter table jin_sale change shipping_price amount_shipping varchar(50) not null default '' after amount_tax_pc;
alter table jin_sale add shipping_subid varchar(255) not null default '' after shipping_id;

create table jin_shipping_due
(
  id           int(11) not null primary key,
  owner_id     int(11) not null,

  sale_id      int(11) not null default 0,
  shipping_id  int(11) not null,

  descr        varchar(255) not null default '',

  fulfilled    int(1) not null default 0,
  
  procid       varchar(50) not null default '',
  status       varchar(255) not null default '',

  key(owner_id,sale_id)
);

alter table jin_role add priv_master_customers_shipdue int(1) not null default 0 after priv_master_customers_jvmsubs;

alter table jin_api_user add secure int(1) not null default 0 after secret;

alter table jin_api_user add   u_all               int(1) not null default 0;
alter table jin_api_user add   u_selected          varchar(255) not null default '';
alter table jin_api_user add   u_since             date null;
alter table jin_api_user add   u_cust_new          int(1) not null default 0;
alter table jin_api_user add   u_cust_packs        varchar(255) not null default '';
alter table jin_api_user add   u_cust_prods        varchar(255) not null default '';
alter table jin_api_user add   u_affprogs          varchar(255) not null default '';
alter table jin_api_user add   u_roles             varchar(255) not null default '';
alter table jin_api_user add   u_rmems             varchar(255) not null default '';
alter table jin_api_user add   u_lmems             varchar(255) not null default '';
alter table jin_api_user add   u_paid_min          varchar(20) not null default '';
alter table jin_api_user add   u_paid_max          varchar(20) not null default '';
alter table jin_api_user add   u_generated_min     varchar(20) not null default '';
alter table jin_api_user add   u_generated_max     varchar(20) not null default '';
alter table jin_api_user add   u_count_sales_from  date null;
alter table jin_api_user add   u_count_sales_until date null;

alter table jin_product add master_prods varchar(50) not null default '' after specusers_excuse;

alter table jin_lmem add use_altauth int(1) not null default 0 after comment;
alter table jin_rmem add use_altauth int(1) not null default 0 after comment;

alter table jin_quest add blocking int(1) not null default 0 after instructions;

alter table jin_product add commission_charity_pbase  int(1) not null default 0 after commission_charity_uids;

create index prod_id on jin_sale(prod_id);
