use strict;

return sub
{
	my $dbh = shift;
	
	my $sth = $dbh->prepare("select id, template from jin_template where name='menu_cfg'");
	$sth->execute;
	
	
	while (my $row = $sth->fetchrow_hashref)
	{
		next
			if $row->{template} =~ m/Menu\.Master\.Plugins/g;
		
		my @old_tmpl = split /(\<goth\:set\s+var=["']*Menu\.Master\.Tools["']*[^\>]+\>)/g, $row->{template};
		
		next
			if @old_tmpl != 3;
		
		my $addon = "\n$old_tmpl[1]";
		$addon =~ s/Menu\.Master\.Tools/Menu\.Master\.Plugins/i;
		if ($old_tmpl[1] =~ /menu_master_tools.gif/i)
		{
			$addon =~ s/menu_master_tools\.gif/menu_master_plugins\.gif/i;
		}
		else
		{
			$addon =~ s/(value=["']*)[^'"\>]+(['"]*)/$1Plugins$2/i;
		}
		
		my @new_tmpl = ($old_tmpl[0], $old_tmpl[1], $addon, $old_tmpl[2]);
		
		$dbh->do("UPDATE jin_template SET template=".$dbh->quote(join "", @new_tmpl)." WHERE id=$row->{id}");
	}
	
	
	my $sth = $dbh->prepare("select id, cover_url, download_url, testim_video_url from jin_jvevent_prod");
	$sth->execute;
	
	while (my $row = $sth->fetchrow_hashref)
	{
		my $cover_url = $row->{cover_url};
		my $download_url = $row->{download_url};
		my $testim_video_url = $row->{testim_video_url};
		
		$_ =~ s!.*files/jvevent_prods.*!!i for $cover_url, $download_url, $testim_video_url;
			
		next
			if $cover_url eq $row->{cover_url} && $download_url eq $row->{download_url} && $testim_video_url eq $row->{testim_video_url};
		
		$dbh->do("UPDATE jin_jvevent_prod SET cover_url=?, download_url=?, testim_video_url=?  WHERE id=$row->{id}", undef, $cover_url, $download_url, $testim_video_url);
	}
	
	
	my $jvprodDir = $main::In{FantasosDir} . '/files/jvevent_prods/';
	
	local *D;
	opendir D, $jvprodDir;
	my @jvprodDirs = readdir D;
	splice @jvprodDirs, 0, 2;
	closedir D;
	
	for my $d (@jvprodDirs)
	{
		local *D;
		opendir D, "$jvprodDir/$d";
		my @files = readdir D;
		splice @files, 0, 2;
		closedir D;
		for my $f (@files)
		{
			my $new_name = $f;
			
			if ($new_name =~ /user_image/i)
			{
				$new_name =~ s/user_image/partner_photo_upload/i;
			}
			elsif ($new_name =~ /prod_image/i)
			{
				$new_name =~ s/prod_image/cover_upload/i;
			}
			elsif ($new_name =~ /prod_download/i)
			{
				$new_name =~ s/prod_download/download_upload/i;
			}
			elsif ($new_name =~ /videofile/i)
			{
				$new_name =~ s/videofile/testim_video_upload/i;
			}
			
			rename("$jvprodDir/$d/$f", "$jvprodDir/$d/$new_name")
				if $new_name ne $f;
		}
	}
	
	return;
};
