
alter table jin_role add priv_master_tools_customtags int(1) not null default 0 after priv_master_tools_emails;

alter table jin_package add aff_customtags varchar(255) not null default '' after promo_window_height;

create table jin_customtag
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  tagname     varchar(50) not null default '',
  comment     varchar(255) not null default '',
  def_value   text not null default '',
  
  unique key(owner_id,tagname)
);

create table jin_customtag_aff
(
  aff_user_id   int(11) not null default 0,
  pack_id       int(11) not null default 0,
  tag_id        int(11) not null default 0,
    
  tag_value     text not null default '',
  
  unique key(pack_id,tag_id,aff_user_id)
);

alter table jin_role add priv_master_tools_linkdirs int(1) not null default 0 after priv_master_tools_supro;

create table jin_linkdir
(
  id                    int(11) not null primary key,
  owner_id              int(11) not null,
  
  title                 varchar(255) not null default '',
  categories            text not null default '',
  
  first_page_size       int(11) not null default 0,
  
  style_id              int(11) not null default 0,
  
  allow_visitors_links  int(1) not null default 0,
  
  sponsor_rmem          int(11) not null default 0,
  sponsor_numlinks      int(11) not null default 0,
  sponsor_orderlink     varchar(255) not null default '',
  
  key(owner_id)
);

create table jin_linkdir_link
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  signature   char(16) not null,
  
  linkdir_id  int(11) not null default 0,
  category    varchar(255) not null default '',

  pdate       datetime null,
  onhold      int(1) not null default 0,

  title       varchar(255) not null default '',
  url         varchar(255) not null default '',
  descr       text not null default '',
  email       varchar(255) not null,
  
  key(owner_id,linkdir_id,onhold),
  key(owner_id,linkdir_id,email)
);


alter table jin_role CHANGE priv_master_tools_jvevents priv_master_plugins_jvevents int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_followupman priv_master_plugins_followupman int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_testimonials priv_master_plugins_testimonials int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_alerts priv_master_plugins_alerts int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_linkdirs priv_master_plugins_linkdirs int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_supro priv_master_plugins_supro int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_sponsorships priv_master_plugins_sponsorships int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_promogen priv_master_plugins_promogen int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_role CHANGE priv_master_tools_invoicepdfs priv_master_plugins_invoicepdfs int(1) not null default 0 after priv_master_tools_extscripts;

alter table jin_jvevent_prod drop videofile;
alter table jin_jvevent_prod drop user_image;

alter table jin_jvevent_prod CHANGE prod_image cover_url varchar(255) not null default '';
alter table jin_jvevent_prod CHANGE prod_download download_url varchar(255) not null default '';

alter table jin_jvevent_prod CHANGE name partner_name varchar(255) not null default '';
alter table jin_jvevent_prod CHANGE email partner_email varchar(255) not null default '';
alter table jin_jvevent_prod CHANGE website_title partner_website_title varchar(255) not null default '';
alter table jin_jvevent_prod CHANGE website_url partner_website_url varchar(255) not null default '';

alter table jin_jvevent_prod CHANGE testimonial testim_text text not null default '';
alter table jin_jvevent_prod CHANGE player testim_player varchar(30) not null default '';
alter table jin_jvevent_prod CHANGE youtube_id testim_youtube varchar(30) not null default '';
alter table jin_jvevent_prod CHANGE video_url testim_video_url varchar(255) not null default '';


alter table jin_role add priv_master_plugins_banner int(1) not null default 0 after priv_master_plugins_supro;

alter table jin_sale modify aff_camp_id varchar(255) not null default '';
alter table jin_package_hit modify camp_id varchar(255) not null default '';
alter table jin_order modify aff_camp_id varchar(255) not null default '';

create table jin_banner
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  title       varchar(255) not null default '',
  
  key(owner_id)
);

create table jin_banner_item
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  banner_id   int(11) not null default 0,
  
  title       varchar(255) not null default '',
  url         varchar(255) not null default '',
  weight      varchar(10) not null default '',
  image       varchar(255) not null default '',
  
  key(owner_id, banner_id)
);

create table jin_banner_stat
(
  banner_id   int(11) not null default 0,
  item_id     int(11) not null default 0,
  referer     varchar(255) not null default '',
  views       int(11) not null default 0,
  clicks      int(11) not null default 0,

  key(banner_id, item_id, referer)
);


alter table jin_role add priv_master_plugins_affinbs int(1) not null default 0 after priv_master_plugins_jvevents;

create table jin_affinb
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,
  
  aff_id    int(11) not null default 0,
  pack_id   int(11) not null default 0,
  
  active    int(1) not null default 0,
  
  descr           longtext not null default '',
  html_delivery   longtext not null default '',
  email_delivery  text not null default '',
  
  key(owner_id,aff_id,pack_id)
);

create table jin_affinb_cfg
(
  id           int(11) not null primary key,
  owner_id     int(11) not null,
  
  affprogs     varchar(255) not null default '',
  
  key(owner_id)
);

create table jin_affinb_template
(
  id           int(11) not null primary key,
  owner_id     int(11) not null,
  
  template     longtext not null default '',
  
  key(owner_id)
);


alter table jin_role drop priv_master_store_pgates;

alter table jin_product add quickresell_enabled int(1) not null default 0 after comm_recur_stop;
alter table jin_product add quickresell_commission_royalty varchar(50) not null default '' after quickresell_enabled;
alter table jin_product add quickresell_price_min varchar(10) not null default '' after quickresell_commission_royalty;
alter table jin_product add quickresell_price_max varchar(10) not null default '' after quickresell_price_min;
alter table jin_product add quickresell_instructions text not null default '' after quickresell_price_max;

alter table jin_package add quickresell_affprogs varchar(255) not null default '' after affprogs;

alter table jin_sale add is_quickresell int(1) not null default 0 after aweber_done;

create table jin_quickresell
(
  id          int(11) not null primary key,
  owner_id    int(11) not null,
  
  prod_id     int(11) not null default 0,
  price       decimal(8,2) not null default '0',
  pgates      varchar(255) not null default '',
  
  key(owner_id,prod_id),
  key(prod_id)
);

alter table jin_quest add   from_customer  int(1) not null default 0 after blocking;
alter table jin_order add key(owner_id,aff_user_id);
alter table jin_sale add key(owner_id,aff_user_id);


alter table jin_jvevent add user_image_width int(11) not null default 0 after def_user_image;
alter table jin_testimonial_page add photo_width int(11) not null default 0 after ipp;


alter table jin_product add specprice decimal(8,2) not null default '0' after specusers_excuse;
alter table jin_product add specprice_users int(11) not null default 0 after specprice;

alter table jin_coupon add otc_lmems varchar(255) not null default '' after otc_existing_prod;
alter table jin_coupon add otc_rmems varchar(255) not null default '' after otc_lmems;
alter table jin_coupon add otc_cmsmems varchar(255) not null default '' after otc_rmems;
