alter table jin_download add title varchar(255) not null default '' after signature;


alter table jin_role add priv_master_store_specprices int(1) not null default 0 after priv_master_store_jvproducts;
alter table jin_product add specprices_plan int(11) not null default 0 after specprice;

create table jin_specprices
(
  id             int(11) not null primary key,
  owner_id       int(11) not null,
  
  title          varchar(255) not null default '',
  settings       text not null default '',
  
  key(owner_id)
);


alter table jin_shopcart_settings add gallery_img_height int(11) not null default 0 after prodinfo_img_width;

alter table jin_merchant_settings add aff_cookie_mode int(1) not null default 0 after limit_user_reg_ip;

alter table jin_package add html_foot text not null default '' after html_head;

alter table jin_sale add specprice_descr varchar(100) not null default '' after shipping_subid;


create table jin_massmail_job
(
  job_id        char(16) not null,

  cdate         datetime null,
  fdate         datetime null,
  ldate         datetime null,

  user_id       int(11) not null,
  subject       varchar(255) not null default '',
  scheduled     int(1) not null default 0,
  
  emails_num    int(11) not null default 0,
  emails_sent   int(11) not null default 0,
  complete      int(1) not null default 0,

  key(job_id),
  key(scheduled,complete),
  key(user_id,scheduled,complete)
);

create table jin_massmail_jobitem
(
  job_id          char(16) not null,
  seq             int(11) not null default 0,
  
  sent            int(1) not null default 0,
  failed          varchar(100) not null default '',
  
  format          varchar(50) not null default '',
  subject         varchar(255) not null default '',
  message         text not null default '',
  
  user_id         int(11) not null,
  user_signature  char(16) not null,
  user_name       varchar(255) not null default '',
  user_email      varchar(255) not null default '',
  user_passwd     varchar(255) not null default '',
  
  key(job_id,seq),
  key(job_id,sent,seq)
);

create table jin_massmail_settings
(
  id            int(11) not null primary key,
  owner_id      int(11) not null,
  
  portion_size  int(11) not null default 0,

  key(owner_id)
);


alter table jin_role add priv_master_plugins_clouds int(1) not null default 0 after priv_master_plugins_certman;

create table jin_cloud_page
(
  id                  int(11) not null primary key,
  owner_id            int(11) not null,
  
  title               varchar(255) not null default '',
  
  pre_moderation      int(1) not null default 0,
  pagesize            int(3) not null default 0,
  remain_on_top_days  int(3) not null default 0,
  status_list         varchar(255) not null default '',
  
  template            longtext not null default '',
  css_style           text not null default '',
  
  key(owner_id)
);

create table jin_cloud
(
  id                int(11) not null primary key,
  owner_id          int(11) not null,
  signature         char(8) not null default '',
  
  cloud_page_id     int(11) not null,
  user_id           int(11) not null,
  ctime             datetime null,
  
  approved          int(1) not null default 0,
  
  title             varchar(255) not null default '',
  message           text not null default '',
  
  status            varchar(50) not null default '',
  votes_for         int(11) not null default 0,
  votes_against     int(11) not null default 0,
  rating            int(11) not null default 0,
  
  starred_by_users  text not null default '',
  
  key(owner_id,cloud_page_id,ctime),
  key(owner_id,cloud_page_id,rating,ctime)
);

create table jin_cloud_comment
(
  id        int(11) not null primary key,
  owner_id  int(11) not null,
  signature char(8) not null default '',
  
  ctime     datetime null,
  cloud_id  int(11) not null,
  user_id   int(11) not null,
  
  message   text not null default '',
  
  key(owner_id,cloud_id,ctime)
);

create table jin_cloud_starred
(
  cloud_id  int(11) not null default 0,
  user_id   int(11) not null default 0,
  
  key(cloud_id,user_id)
);


alter table jin_role add priv_master_plugins_multrec int(1) not null default 0 after priv_master_plugins_clouds;

alter table jin_product modify specprice text not null default '';
