alter table jin_role add priv_master_plugins_reminders int(1) not null default 0 after priv_master_plugins_multrec;

create table jin_reminder
(
  id              int(11) NOT NULL  primary key,
  owner_id        int(11) NOT NULL,
  
  type            varchar(100) NOT NULL default '',
  title           varchar(255) NOT NULL default '',
  comment         text NOT NULL,
  event_date      datetime default NULL,
  remind_date     datetime default NULL,
  recurring       tinyint(2) NOT NULL default '0',
  recur_until     datetime default NULL,
  
  key(owner_id)
);

create table jin_reminder_type
(
  owner_id        int(11) NOT NULL default '0',
  
  title           varchar(100) NOT NULL default '',
  
  key(owner_id)
);

alter table jin_role add priv_member_account_helptickets int(1) not null default 0 after priv_member_account_points;
alter table jin_role add priv_master_plugins_helptickets int(1) not null default 0 after priv_master_plugins_reminders;

create table jin_helpticket
(
  id                  int(11) not null primary key,
  owner_id            int(11) not null,
  
  thread_id           int(11) not null default 0,
  user_id             int(11) not null default 0,
  
  subject             varchar(255) not null default '',
  message             text not null default '',
  
  ctime               datetime null,
  ftime               datetime null,
  
  status              int(8) not null default 0,
  
  category            varchar(255) not null default '',
  
  key(owner_id,thread_id,status,ctime)
);

create table jin_helpticket_settings
(
  id                  int(11) not null primary key,
  owner_id            int(11) not null,
  
  template            longtext not null default '',
  
  categories          text not null default '',
  
  support_emails      text not null default '',
  staff_emails        text not null default '',
  
  admin_name          varchar(255) not null default '',
  admin_signature     text not null default '',
  
  key(owner_id)
);

