use strict;

return sub
{
	my $dbh = shift;
	

	my $sth = $dbh->prepare("select id, template from jin_template where tmpl_type='order_thank'");
	$sth->execute;
	
	while (my $row = $sth->fetchrow_hashref)
	{
		next
			if $row->{template} =~ m/HasLessonSeries/g;
		
		my @old_t = split /(\<goth\:if\s+var=["']*HasMembership["']*\>)/g, $row->{template};
		
		next
			if @old_t < 2;
		
		my @new_t;
		push @new_t, $old_t[0];
		push @new_t, '<goth:if var=HasLessonSeries>';
		push @new_t, '    <div class="jinOrderSectionTitle">Lesson series</div>';
		push @new_t, '    <div class="jinOrderSection">#{lesson_series}</div>';
		push @new_t, '</goth:if>';
		push @new_t, '';
		push @new_t, $old_t[1];
		push @new_t, $old_t[2];
		
		$dbh->do("UPDATE jin_template SET template=".$dbh->quote(join "\n", @new_t)." WHERE id=$row->{id}");
	}
	
	
	my $sth = $dbh->prepare("select id, template from jin_template where tmpl_type='order_thank'");
	$sth->execute;
	
	while (my $row = $sth->fetchrow_hashref)
	{
		next
			if $row->{template} =~ m/HasReflink/g;
		
		my @old_t = split /(\<goth\:if\s+var=["']*HasDownload["']*\>)/g, $row->{template};
		
		next
			if @old_t < 2;
		
		my @new_t;
		push @new_t, $old_t[0];
		push @new_t, '<goth:if var=HasReflink>';
		push @new_t, '    <div class="jinOrderSectionTitle">[::L ##en Affiliate links ::]</div>';
		push @new_t, '    <div class="jinOrderSection">#{reflink}</div>';
		push @new_t, '</goth:if>';
		push @new_t, '';
		push @new_t, $old_t[1];
		push @new_t, $old_t[2];
		$dbh->do("UPDATE jin_template SET template=".$dbh->quote(join "\n", @new_t)." WHERE id=$row->{id}");
	}
	
	return;
};
