alter table zen_labelling add id int(11) primary key auto_increment;
alter table zen_labelling change label title varchar(100) not null default '';

update jin_template set template=replace(template,'Authorization required','#{HTMLTitle}') where tmpl_type='auth';

alter table jin_helpticket_settings drop admin_name;
alter table jin_helpticket_settings drop admin_signature;
alter table jin_helpticket_settings drop categories;
alter table jin_helpticket_settings drop support_emails;
alter table jin_helpticket_settings drop staff_emails;

create table jin_helpticket_category
(
  id                  int(11) not null primary key,

  title               varchar(255) not null default '',
  pipe_email          varchar(50) not null default '',
  staff_ids           varchar(255) not null default '',
  staff_signature     text not null default '',
  subject_prefix      varchar(50) not null default '',
  membership_ids      varchar(255) not null default '',
  membership_error    text not null default ''
);

alter table jin_helpticket_settings change template submit_instr text not null default '';
update jin_helpticket_settings set submit_instr='';

alter table jin_helpticket add ticket_code char(10) not null default '' after id;
alter table jin_helpticket add is_initial int(1) not null default 0 after ticket_code;
create index ticket_code on jin_helpticket(ticket_code);
create index is_initial on jin_helpticket(is_initial);

update jin_helpticket set is_initial=1 where thread_id=0 and ticket_code='';

drop index owner_id on jin_helpticket;
create index status on jin_helpticket(status,ctime);

alter table jin_helpticket modify status int(1) not null default 1;
update jin_helpticket set status=3 where status=0;

alter table jin_helpticket change ftime tstamp_activity datetime null;
update jin_helpticket set tstamp_activity=ctime;
