CREATE TABLE IF NOT EXISTS `jin_ext_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
);

CREATE TABLE IF NOT EXISTS `jin_extint_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`user_id`,`title`)
);  

CREATE TABLE IF NOT EXISTS `jin_extint_acts_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extint_action` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `done` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
);

CREATE TABLE IF NOT EXISTS `jin_extint_acts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extint_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  `trigger_id` tinyint(4) NOT NULL,
  `action_id` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`extint_id`,`product_id`,`trigger_id`,`action_id`,`tag_id`)
);

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'jin_product'
        AND table_schema = DATABASE()
        AND column_name = 'extints'
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `jin_product` ADD `extints` varchar(255) NOT NULL DEFAULT '' AFTER `pgates`"
));

PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

SET @s = (SELECT IF(
    (SELECT COUNT(*)
        FROM INFORMATION_SCHEMA.COLUMNS
        WHERE table_name = 'jin_specusers'
        AND table_schema = DATABASE()
        AND column_name = 'f_cond_and__u_cust_packs'
    ) > 0,
    "SELECT 1",
    "ALTER TABLE `jin_specusers` ADD `f_cond_and__u_cust_packs` varchar(255) NOT NULL DEFAULT '' AFTER `u_cust_packs`,
ADD `f_cond_or__u_cust_packs` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_cust_packs`,
ADD `f_cond_not__u_cust_packs` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_cust_packs`,
ADD `f_cond_and__u_cust_prods` varchar(255) NOT NULL DEFAULT '' AFTER `u_cust_prods`,
ADD `f_cond_or__u_cust_prods` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_cust_prods`,
ADD `f_cond_not__u_cust_prods` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_cust_prods`,
ADD `f_cond_and__u_affprogs` varchar(255) NOT NULL DEFAULT '' AFTER `u_affprogs`,
ADD `f_cond_or__u_affprogs` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_affprogs`,
ADD `f_cond_not__u_affprogs` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_affprogs`,
ADD `f_cond_and__u_roles` varchar(255) NOT NULL DEFAULT '' AFTER `u_roles`,
ADD `f_cond_or__u_roles` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_roles`,
ADD `f_cond_not__u_roles` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_roles`,
ADD `f_cond_and__u_memberships` varchar(255) NOT NULL DEFAULT '' AFTER `u_memberships`,
ADD `f_cond_or__u_memberships` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_memberships`,
ADD `f_cond_not__u_memberships` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_memberships`,
ADD `f_cond_and__u_insignia` varchar(255) NOT NULL DEFAULT '' AFTER `u_insignia`,
ADD `f_cond_or__u_insignia` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_and__u_insignia`,
ADD `f_cond_not__u_insignia` varchar(255) NOT NULL DEFAULT '' AFTER `f_cond_or__u_insignia`"
));

PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;