SET SQL_MODE = "";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


CREATE TABLE IF NOT EXISTS `jin_abandone` (
  `tstamp` datetime DEFAULT NULL,
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pack_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affiliate_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `autoresp_me2cust_ids` varchar(255) NOT NULL DEFAULT '',
  `autoresp_me2refered_ids` varchar(255) NOT NULL DEFAULT '',
  `email_me2refered` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affinb` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `aff_id` int(11) NOT NULL DEFAULT '0',
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '0',
  `descr` longtext NOT NULL,
  `html_delivery` longtext NOT NULL,
  `email_delivery` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aff_id` (`aff_id`,`pack_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affinb_cfg` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `affprogs` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affinb_template` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `template` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affprog` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `commission_special` varchar(255) NOT NULL DEFAULT '',
  `needapproval` int(1) NOT NULL DEFAULT '0',
  `autoresp_ids` varchar(255) NOT NULL DEFAULT '',
  `email_welcome` text NOT NULL,
  `comm100` int(1) NOT NULL DEFAULT '0',
  `adaptcomm` int(1) NOT NULL DEFAULT '0',
  `comm_recur_stop` int(3) NOT NULL DEFAULT '0',
  `period_guarantee` int(11) NOT NULL DEFAULT '0',
  `period_guarantee_no4recur` int(1) NOT NULL DEFAULT '0',
  `aff_instcomm_on` int(1) NOT NULL DEFAULT '0',
  `aff_instcomm_percent` int(3) NOT NULL DEFAULT '0',
  `aff_instcomm_order` int(1) NOT NULL DEFAULT '0',
  `aff_instcomm_tstamp` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affprog_series` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affprog_series_history` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `series_id` int(11) NOT NULL,
  `otime` datetime DEFAULT NULL,
  `affprog_id_before` int(11) NOT NULL,
  `affprog_title_before` varchar(255) NOT NULL DEFAULT '',
  `affprog_id_after` int(11) NOT NULL,
  `affprog_title_after` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_affprog_series_step` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `series_id` int(11) NOT NULL DEFAULT '0',
  `affprog_id` int(11) NOT NULL DEFAULT '0',
  `upgrade_type` varchar(20) NOT NULL DEFAULT '',
  `upgrade_amount` varchar(20) NOT NULL DEFAULT '',
  `upgrade_period_n` varchar(10) NOT NULL DEFAULT '',
  `upgrade_period_u` char(1) NOT NULL DEFAULT '0',
  `downgrade_type` varchar(20) NOT NULL DEFAULT '',
  `downgrade_amount` varchar(20) NOT NULL DEFAULT '',
  `downgrade_period_n` varchar(10) NOT NULL DEFAULT '',
  `downgrade_period_u` char(1) NOT NULL DEFAULT '0',
  `email_upgrade` text NOT NULL,
  `email_downgrade` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_alert_cfg` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ad` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_alert_msg` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ptime` datetime DEFAULT NULL,
  `specusers` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_alert_sync` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `last_sync_time` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_api_gate` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `apikey` varchar(255) NOT NULL DEFAULT '',
  `apicalls` varchar(255) NOT NULL DEFAULT '',
  `specusers` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_api_post` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `method` varchar(4) NOT NULL DEFAULT '',
  `events` varchar(50) NOT NULL DEFAULT '',
  `mod_plugin` varchar(20) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_api_user` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `secure` int(1) NOT NULL DEFAULT '0',
  `specusers` int(11) NOT NULL DEFAULT '0',
  `u_all` int(1) NOT NULL DEFAULT '0',
  `u_selected` varchar(255) NOT NULL DEFAULT '',
  `u_since` date DEFAULT NULL,
  `u_cust_new` int(1) NOT NULL DEFAULT '0',
  `u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `u_roles` varchar(255) NOT NULL DEFAULT '',
  `u_memberships` varchar(255) NOT NULL DEFAULT '',
  `u_insignia` varchar(255) NOT NULL DEFAULT '',
  `u_surveys` varchar(255) NOT NULL DEFAULT '',
  `u_paid_min` varchar(20) NOT NULL DEFAULT '',
  `u_paid_max` varchar(20) NOT NULL DEFAULT '',
  `u_generated_min` varchar(20) NOT NULL DEFAULT '',
  `u_generated_max` varchar(20) NOT NULL DEFAULT '',
  `u_count_sales_from` date DEFAULT NULL,
  `u_count_sales_until` date DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_autoresponder` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `settings` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_backlink` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descr` varchar(150) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `rating_self` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `last_id` int(11) NOT NULL DEFAULT '0',
  `last_ip` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rating` (`rating`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ban` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `banlist` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_banner` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_banner_item` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `banner_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `weight` varchar(10) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `html_text` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `banner_id` (`banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_banner_stat` (
  `banner_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `referer` varchar(255) NOT NULL DEFAULT '',
  `views` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `banner_id` (`banner_id`,`item_id`,`referer`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_bcastnews` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `display_on_ws` int(1) NOT NULL DEFAULT '0',
  `display_mode` int(3) NOT NULL DEFAULT '0',
  `display_mode_value` int(3) NOT NULL DEFAULT '0',
  `secret_word` varchar(50) NOT NULL DEFAULT '',
  `template` text NOT NULL,
  `template_one_msg` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_bcastnews_feeder` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `secret_word` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_bcastnews_message` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `pdate` datetime DEFAULT NULL,
  `message_brief` text NOT NULL,
  `message_full` text NOT NULL,
  `author` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pdate` (`pdate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_blogpub` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `blog_type` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `format` int(1) NOT NULL DEFAULT '0',
  `login_url` varchar(255) NOT NULL DEFAULT '',
  `login_params` text NOT NULL,
  `pub_url` varchar(255) NOT NULL DEFAULT '',
  `pub_params` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_brandpdf` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `filename` varchar(150) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_campaign` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `aff_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `affprogs` varchar(255) NOT NULL DEFAULT '',
  `unify_pack_hits` int(1) NOT NULL DEFAULT '0',
  `unify_order_sales` int(1) NOT NULL DEFAULT '0',
  `count_only_packs` varchar(255) NOT NULL DEFAULT '',
  `count_only_prods` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aff_id` (`aff_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ccs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ts` datetime DEFAULT NULL,
  `d` tinyblob NOT NULL,
  `e` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `e` (`e`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_certman` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `date_color` varchar(11) NOT NULL DEFAULT '',
  `date_font` int(8) NOT NULL DEFAULT '0',
  `date_format` varchar(30) NOT NULL DEFAULT '',
  `date_x` int(8) NOT NULL DEFAULT '0',
  `date_y` int(8) NOT NULL DEFAULT '0',
  `id_color` varchar(11) NOT NULL DEFAULT '',
  `id_font` int(8) NOT NULL DEFAULT '0',
  `id_x` int(8) NOT NULL DEFAULT '0',
  `id_y` int(8) NOT NULL DEFAULT '0',
  `name_color` varchar(11) NOT NULL DEFAULT '',
  `name_font` int(8) NOT NULL DEFAULT '0',
  `name_x` int(8) NOT NULL DEFAULT '0',
  `name_y` int(8) NOT NULL DEFAULT '0',
  `copyright` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `width` int(8) NOT NULL DEFAULT '0',
  `height` int(8) NOT NULL DEFAULT '0',
  `nc_url` varchar(255) NOT NULL DEFAULT '',
  `nc_template` longtext NOT NULL,
  `nc_width` int(8) NOT NULL DEFAULT '0',
  `nc_height` int(8) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_cloud` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `cloud_page_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ctime` datetime DEFAULT NULL,
  `approved` int(1) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `status` varchar(50) NOT NULL DEFAULT '',
  `votes_for` int(11) NOT NULL DEFAULT '0',
  `votes_against` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `starred_by_users` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cloud_page_id` (`cloud_page_id`,`ctime`),
  KEY `cloud_page_id_2` (`cloud_page_id`,`rating`,`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_cloud_comment` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `ctime` datetime DEFAULT NULL,
  `cloud_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cloud_id` (`cloud_id`,`ctime`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_cloud_page` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `pre_moderation` int(1) NOT NULL DEFAULT '0',
  `pagesize` int(3) NOT NULL DEFAULT '0',
  `remain_on_top_days` int(3) NOT NULL DEFAULT '0',
  `status_list` varchar(255) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `css_style` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_cloud_starred` (
  `cloud_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `cloud_id` (`cloud_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_commission` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `type` varchar(50) NOT NULL,
  `descr` varchar(255) NOT NULL DEFAULT '',
  `amount` varchar(50) NOT NULL,
  `tier` int(1) NOT NULL DEFAULT '0',
  `pay_deadline` date DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT '0',
  `paid_tstamp` datetime DEFAULT NULL,
  `cancel_deadline` date DEFAULT NULL,
  `cancelled` int(1) NOT NULL DEFAULT '0',
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `payer_user_id` int(11) NOT NULL DEFAULT '0',
  `ben_user_id` int(11) NOT NULL DEFAULT '0',
  `ben_user_name` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sale_id` (`sale_id`),
  KEY `ben_user_id` (`ben_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_content_series` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `start_time` datetime DEFAULT NULL,
  `membership_id` int(11) NOT NULL,
  `loop_enabled` int(1) NOT NULL DEFAULT '0',
  `delay_for_n` varchar(10) NOT NULL DEFAULT '',
  `delay_for_u` char(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_content_series_step` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `series_id` int(11) NOT NULL DEFAULT '0',
  `display_for_n` varchar(10) NOT NULL DEFAULT '',
  `display_for_u` char(1) NOT NULL DEFAULT '0',
  `title` varchar(30) NOT NULL,
  `content` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `series_id` (`series_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_coupon` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `hidden` int(1) NOT NULL DEFAULT '0',
  `parent_coupon_id` int(11) NOT NULL,
  `active` int(1) NOT NULL DEFAULT '0',
  `exhausted` int(1) NOT NULL DEFAULT '0',
  `otc_all` int(1) NOT NULL DEFAULT '0',
  `otc_selected` varchar(255) NOT NULL DEFAULT '',
  `otc_existing_since` date DEFAULT NULL,
  `otc_existing_pack` varchar(255) NOT NULL DEFAULT '',
  `otc_existing_prod` varchar(255) NOT NULL DEFAULT '',
  `otc_memberships` varchar(255) NOT NULL DEFAULT '',
  `otc_new` int(1) NOT NULL DEFAULT '0',
  `otc_new_pack` varchar(255) NOT NULL DEFAULT '',
  `otc_new_prod` varchar(255) NOT NULL DEFAULT '',
  `ota_all` int(1) NOT NULL DEFAULT '0',
  `ota_selected` varchar(255) NOT NULL DEFAULT '',
  `ota_group` varchar(255) NOT NULL DEFAULT '',
  `ota_existing` int(1) NOT NULL DEFAULT '0',
  `ota_existing_since` date DEFAULT NULL,
  `ota_new` int(1) NOT NULL DEFAULT '0',
  `for_all` int(1) NOT NULL DEFAULT '0',
  `for_pack` varchar(255) NOT NULL DEFAULT '',
  `for_prod` varchar(255) NOT NULL DEFAULT '',
  `coupon` varchar(255) NOT NULL DEFAULT '0',
  `discount` varchar(50) NOT NULL DEFAULT '',
  `limit_amount` int(11) NOT NULL DEFAULT '0',
  `mode` int(1) NOT NULL DEFAULT '0',
  `valid_from` date DEFAULT NULL,
  `valid_until` date DEFAULT NULL,
  `number` int(11) NOT NULL DEFAULT '0',
  `usage_cust` int(11) NOT NULL DEFAULT '0',
  `usage_aff` int(11) NOT NULL DEFAULT '0',
  `email_cust` text NOT NULL,
  `email_aff` text NOT NULL,
  `notes` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `hidden` (`hidden`),
  KEY `coupon` (`coupon`),
  KEY `parent_coupon_id` (`parent_coupon_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_coupon_use` (
  `coupon_id` int(11) NOT NULL DEFAULT '0',
  `cust_user_id` int(11) NOT NULL DEFAULT '0',
  `aff_user_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `coupon_id` (`coupon_id`),
  KEY `cust_user_id` (`cust_user_id`),
  KEY `aff_user_id` (`aff_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_customtag` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `tagname` varchar(50) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `def_value` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tagname` (`tagname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_customtag_aff` (
  `aff_user_id` int(11) NOT NULL DEFAULT '0',
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  `tag_value` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `pack_id` (`pack_id`,`tag_id`,`aff_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_datalog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `sqltable` varchar(30) NOT NULL DEFAULT '',
  `record_id` int(11) NOT NULL DEFAULT '0',
  `sqlfield` varchar(30) NOT NULL DEFAULT '',
  `value1` varchar(255) NOT NULL DEFAULT '',
  `value2` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sqltable` (`sqltable`,`sqlfield`,`record_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_dbbackup` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `enabled` int(1) NOT NULL DEFAULT '0',
  `period_u` char(1) NOT NULL DEFAULT '0',
  `ftp_serv` varchar(255) NOT NULL,
  `ftp_user` varchar(255) NOT NULL,
  `ftp_pass` varchar(255) NOT NULL,
  `ftp_dir` varchar(255) NOT NULL,
  `limit_backups` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_download` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_emaildlv` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `anchor_code` varchar(70) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `from_name` varchar(255) NOT NULL DEFAULT '',
  `from_email` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `delay` int(3) NOT NULL DEFAULT '0',
  `disabled` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `anchor_code` (`anchor_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_emaildlv_delayed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `tstamp_send` datetime DEFAULT NULL,
  `serialized` blob NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tstamp_send` (`tstamp_send`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_embedded_email` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` text NOT NULL,
  `footermassmail` text NOT NULL,
  `footerdownline` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_external_ipn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `pgate_id` int(11) NOT NULL DEFAULT '0',
  `pgate_title` varchar(50) NOT NULL DEFAULT '',
  `ip` varchar(32) NOT NULL DEFAULT '',
  `tstamp` datetime DEFAULT NULL,
  `verified` int(1) NOT NULL DEFAULT '0',
  `fingerprint` varchar(32) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fingerprint` (`fingerprint`),
  KEY `sale_id` (`sale_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_extint_acts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `extint_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  `trigger_id` tinyint(4) NOT NULL,
  `action_id` tinyint(4) DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`extint_id`,`product_id`,`trigger_id`,`action_id`,`tag_id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_extint_acts_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `extint_action` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `done` tinyint(4) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1619 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_extint_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`user_id`,`title`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ext_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `settings` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ext_script` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `cfgtext` text NOT NULL,
  `email_create` text NOT NULL,
  `email_delete` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ext_script_action` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ext_script_id` int(11) DEFAULT NULL,
  `case` tinyint(1) DEFAULT NULL,
  `action` tinyint(1) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `donr` int(3) DEFAULT NULL,
  `dbs` int(3) DEFAULT NULL,
  `dbt` int(3) DEFAULT NULL,
  `dbs_email` text,
  `dbt_email` text,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IX_UNIQUE_ACTION` (`ext_script_id`,`case`,`action`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ext_script_action_log` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `action_id` int(11) DEFAULT NULL,
  `dlv_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `dt_onr` date DEFAULT NULL,
  `is_onr` tinyint(1) DEFAULT NULL,
  `dt_suspend` date DEFAULT NULL,
  `is_suspended` tinyint(1) DEFAULT '0',
  `dt_terminate` date DEFAULT NULL,
  `is_terminated` tinyint(1) DEFAULT '0',
  `ctime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IX_UNIQUE` (`action_id`,`dlv_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ezine_points` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `points` int(11) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `page` longtext NOT NULL,
  `errmsg` text NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ezine_points_cashed` (
  `ezp_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ezp_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_followupman_series` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `prods` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `from_name` varchar(255) NOT NULL DEFAULT '',
  `from_email` varchar(255) NOT NULL DEFAULT '',
  `double_optin` int(1) NOT NULL DEFAULT '0',
  `hide_thank` int(1) NOT NULL DEFAULT '0',
  `del_series` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_followupman_series_message` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `series_id` int(11) NOT NULL DEFAULT '0',
  `delay` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `seq` int(3) NOT NULL,
  `plain_text` int(1) NOT NULL DEFAULT '0',
  `recur_yes` int(1) NOT NULL DEFAULT '0',
  `recur_num` int(8) NOT NULL DEFAULT '0',
  `recur_delay` int(11) NOT NULL DEFAULT '0',
  `co_mode` int(1) NOT NULL DEFAULT '0',
  `co_from_email` varchar(255) NOT NULL DEFAULT '',
  `co_to_emails` text NOT NULL,
  `co_subject` varchar(255) NOT NULL DEFAULT '',
  `co_message` text NOT NULL,
  `co_plain_text` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `series_id` (`series_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_followupman_template` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `confirm_subscription` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_followupman_user_recur` (
  `user_series_id` int(11) NOT NULL DEFAULT '0',
  `message_id` int(11) NOT NULL DEFAULT '0',
  `num` int(8) NOT NULL DEFAULT '0',
  `stime` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `user_series_id` (`user_series_id`),
  KEY `message_id` (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_followupman_user_series` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `message_id` int(11) NOT NULL DEFAULT '0',
  `series_id` int(11) NOT NULL DEFAULT '0',
  `stime` datetime DEFAULT NULL,
  `confirmed` int(1) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL,
  `optout` int(1) NOT NULL DEFAULT '0',
  `optout_tstamp` datetime DEFAULT NULL,
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `sale_id` (`sale_id`),
  KEY `series_id` (`series_id`),
  KEY `confirmed` (`confirmed`,`optout`,`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_form_editor` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `code` varchar(50) NOT NULL,
  `obj_id` int(11) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_condition` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `step_id` int(11) NOT NULL,
  `set_type` int(1) NOT NULL DEFAULT '0',
  `ord` int(3) NOT NULL DEFAULT '0',
  `cond_type` varchar(10) NOT NULL DEFAULT '',
  `cond_obj_id` int(11) NOT NULL DEFAULT '0',
  `next_step_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `step_id` (`step_id`,`set_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_element` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `tagname` varchar(50) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tagname` (`tagname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_splitpage` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `step_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `weight` int(11) NOT NULL DEFAULT '0',
  `template` longtext NOT NULL,
  `template_comp` longtext NOT NULL,
  `notes` text NOT NULL,
  `is_default` int(1) NOT NULL DEFAULT '0',
  `is_nowedit` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `step_id` (`step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_splittest` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `funnel_id` int(11) NOT NULL,
  `step_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `datetime_from` datetime DEFAULT NULL,
  `datetime_to` datetime DEFAULT NULL,
  `dec_prec` int(1) NOT NULL DEFAULT '0',
  `testusers` varchar(255) NOT NULL DEFAULT '',
  `testips` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `funnel_id` (`funnel_id`),
  KEY `step_id` (`step_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_step` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `funnel_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `pgate` int(11) NOT NULL DEFAULT '0',
  `backpay_override` int(1) NOT NULL DEFAULT '0',
  `backpay_pgates` varchar(50) NOT NULL DEFAULT '',
  `emaildlvs` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `funnel_id` (`funnel_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_funnel_visit` (
  `funnel_id` int(11) NOT NULL,
  `code` char(16) NOT NULL DEFAULT '',
  `tstamp_start` datetime DEFAULT NULL,
  `tstamp` datetime DEFAULT NULL,
  `seq` int(3) NOT NULL DEFAULT '0',
  `step_id` int(11) NOT NULL DEFAULT '0',
  `splitpage_id` int(11) NOT NULL DEFAULT '0',
  `action` varchar(15) NOT NULL DEFAULT '',
  `param_id` int(11) NOT NULL DEFAULT '0',
  `param_text` varchar(255) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `user_ip` varchar(50) NOT NULL DEFAULT '',
  `user_cookie` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `funnel_id` (`funnel_id`,`step_id`),
  KEY `code` (`code`),
  KEY `user_ip` (`user_ip`),
  KEY `user_cookie` (`user_cookie`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_geoforce` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(10) NOT NULL DEFAULT '',
  `state` varchar(10) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_order_link` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `country` (`country`,`state`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_helpticket` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ticket_code` char(10) NOT NULL DEFAULT '',
  `is_initial` int(1) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `ctime` datetime DEFAULT NULL,
  `tstamp_activity` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`ctime`),
  KEY `ticket_code` (`ticket_code`),
  KEY `is_initial` (`is_initial`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_helpticket_category` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `pipe_email` varchar(50) NOT NULL DEFAULT '',
  `staff_ids` varchar(255) NOT NULL DEFAULT '',
  `staff_signature` text NOT NULL,
  `subject_prefix` varchar(50) NOT NULL DEFAULT '',
  `membership_ids` varchar(255) NOT NULL DEFAULT '',
  `specusers_ids` varchar(255) NOT NULL DEFAULT '',
  `access_error` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_helpticket_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `submit_instr` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_insignia_category` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `color` varchar(30) NOT NULL DEFAULT '',
  `fulltitle` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_insignia_group` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_invitation` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `grant_roles` varchar(255) NOT NULL DEFAULT '',
  `grant_affprogs` varchar(255) NOT NULL DEFAULT '',
  `promo_affprogs` varchar(255) NOT NULL DEFAULT '',
  `commission_refer` varchar(255) NOT NULL DEFAULT '',
  `final_html` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_invoicepdf` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `format` varchar(10) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_ipn_forward` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `pgtxn_id` int(11) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `trials` int(3) NOT NULL DEFAULT '3',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_jvevent` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `rights` varchar(255) NOT NULL DEFAULT '',
  `pagesize` int(3) NOT NULL DEFAULT '0',
  `period_validity` int(11) NOT NULL DEFAULT '0',
  `max_video_size` int(6) NOT NULL DEFAULT '0',
  `max_image_size` int(6) NOT NULL DEFAULT '0',
  `max_download_size` int(6) NOT NULL DEFAULT '0',
  `def_user_image` varchar(255) NOT NULL DEFAULT '',
  `user_image_width` int(11) NOT NULL DEFAULT '0',
  `template_list` longtext NOT NULL,
  `template_submit` longtext NOT NULL,
  `style_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `signature` (`signature`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_jvevent_prod` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `ctime` datetime DEFAULT NULL,
  `jvevent_id` int(11) NOT NULL DEFAULT '0',
  `approved` int(1) NOT NULL DEFAULT '0',
  `sortdate` datetime DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `price` varchar(30) NOT NULL DEFAULT '',
  `cover_url` varchar(255) NOT NULL DEFAULT '',
  `download_url` varchar(255) NOT NULL DEFAULT '',
  `rights` varchar(255) NOT NULL DEFAULT '',
  `partner_name` varchar(255) NOT NULL DEFAULT '',
  `partner_email` varchar(255) NOT NULL DEFAULT '',
  `partner_website_title` varchar(255) NOT NULL DEFAULT '',
  `partner_website_url` varchar(255) NOT NULL DEFAULT '',
  `testim_text` text NOT NULL,
  `testim_player` varchar(30) NOT NULL DEFAULT '',
  `testim_youtube` varchar(30) NOT NULL DEFAULT '',
  `testim_video_url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `jvevent_id` (`jvevent_id`,`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_jvevent_rights` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_jvmsub` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `subscr_id` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `init_sale_id` int(11) NOT NULL,
  `startdate` date DEFAULT NULL,
  `active` int(1) NOT NULL,
  `cancelled` int(1) NOT NULL DEFAULT '0',
  `canceldate` date DEFAULT NULL,
  `cancelreason` varchar(255) NOT NULL DEFAULT '',
  `period_l` varchar(20) NOT NULL DEFAULT '',
  `period_u` varchar(20) NOT NULL DEFAULT '',
  `numinst` varchar(20) NOT NULL DEFAULT '',
  `trial_l` varchar(20) NOT NULL DEFAULT '',
  `trial_u` char(1) NOT NULL DEFAULT '',
  `trial_amount` varchar(20) NOT NULL DEFAULT '',
  `period_amount` varchar(20) NOT NULL DEFAULT '',
  `refsale_next_ref_id` varchar(32) NOT NULL DEFAULT '',
  `refsale_failure_tstamp` datetime DEFAULT NULL,
  `refsale_failure_reason` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `init_sale_id` (`init_sale_id`),
  KEY `active` (`active`),
  KEY `subscr_id` (`subscr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_lesson` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `series_id` int(11) NOT NULL,
  `seq` int(3) NOT NULL,
  `title` varchar(50) NOT NULL DEFAULT '',
  `display_for_l` int(11) NOT NULL DEFAULT '0',
  `display_for_u` varchar(10) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `links` text NOT NULL,
  `videos` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `series_id` (`series_id`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_lesson_series` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `email_welcome` text NOT NULL,
  `email_next_lesson` text NOT NULL,
  `email_farewell` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_linkdir` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `categories` text NOT NULL,
  `first_page_size` int(11) NOT NULL DEFAULT '0',
  `style_id` int(11) NOT NULL DEFAULT '0',
  `allow_visitors_links` int(1) NOT NULL DEFAULT '0',
  `sponsor_membership` int(11) NOT NULL DEFAULT '0',
  `sponsor_numlinks` int(11) NOT NULL DEFAULT '0',
  `sponsor_orderlink` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_linkdir_link` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(16) NOT NULL,
  `linkdir_id` int(11) NOT NULL DEFAULT '0',
  `category` varchar(255) NOT NULL DEFAULT '',
  `pdate` datetime DEFAULT NULL,
  `onhold` int(1) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `email` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `linkdir_id` (`linkdir_id`,`onhold`),
  KEY `linkdir_id_2` (`linkdir_id`,`email`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_longtexts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `data` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_massmail_counter` (
  `user_id` int(11) NOT NULL,
  `tstamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_massmail_job` (
  `job_id` char(16) NOT NULL,
  `cdate` datetime DEFAULT NULL,
  `fdate` datetime DEFAULT NULL,
  `ldate` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `scheduled` int(1) NOT NULL DEFAULT '0',
  `emails_num` int(11) NOT NULL DEFAULT '0',
  `emails_sent` int(11) NOT NULL DEFAULT '0',
  `complete` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `job_id` (`job_id`),
  KEY `scheduled` (`scheduled`,`complete`),
  KEY `user_id` (`user_id`,`scheduled`,`complete`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_massmail_jobitem` (
  `job_id` char(16) NOT NULL,
  `seq` int(11) NOT NULL DEFAULT '0',
  `sent` int(1) NOT NULL DEFAULT '0',
  `failed` varchar(100) NOT NULL DEFAULT '',
  `format` varchar(50) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `user_id` int(11) NOT NULL,
  `user_signature` char(16) NOT NULL,
  `user_fname` varchar(50) NOT NULL DEFAULT '',
  `user_lname` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(70) NOT NULL DEFAULT '',
  `user_passwd` varchar(255) NOT NULL DEFAULT '',
  `from_name` varchar(50) NOT NULL DEFAULT '',
  `from_email` varchar(70) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `job_id` (`job_id`,`seq`),
  KEY `job_id_2` (`job_id`,`sent`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_massmail_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `portion_size` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_membership` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL,
  `custom_int` int(11) NOT NULL,
  `custom_v1` varchar(255) NOT NULL,
  `custom_v2` varchar(255) NOT NULL,
  `custom_v3` varchar(255) NOT NULL,
  `custom_v4` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `insecure` int(1) NOT NULL DEFAULT '0',
  `use_altauth` int(1) NOT NULL DEFAULT '0',
  `email_access` text NOT NULL,
  `email_renew` text NOT NULL,
  `email_renew_period` int(11) NOT NULL DEFAULT '0',
  `email_delete` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_merchant_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `sitename` varchar(255) NOT NULL DEFAULT '',
  `from_name` varchar(255) NOT NULL DEFAULT '',
  `from_email` varchar(255) NOT NULL DEFAULT '',
  `tech_email` varchar(255) NOT NULL DEFAULT '',
  `turboaffid` varchar(255) NOT NULL DEFAULT '',
  `help_url_forum` varchar(255) NOT NULL DEFAULT '',
  `help_url_helpdesk` varchar(255) NOT NULL DEFAULT '',
  `autoresp_ma2cust_ids` varchar(255) NOT NULL DEFAULT '',
  `email_ma2cust` text NOT NULL,
  `email_for_errormsg` text NOT NULL,
  `currency` char(3) NOT NULL,
  `backpay_use` int(1) NOT NULL DEFAULT '0',
  `backpay_pgates` varchar(50) NOT NULL DEFAULT '',
  `limit_user_reg_ip` int(4) NOT NULL DEFAULT '0',
  `aff_prevailing_mode` int(1) NOT NULL DEFAULT '0',
  `force_https` int(1) NOT NULL DEFAULT '0',
  `reg_1optin` int(1) NOT NULL DEFAULT '0',
  `reg_cfm_url` varchar(255) NOT NULL DEFAULT '',
  `first_login_url` varchar(255) NOT NULL DEFAULT '',
  `autoassign_memberships` varchar(255) NOT NULL DEFAULT '',
  `autoassign_roles` varchar(255) NOT NULL DEFAULT '',
  `autoassign_affprogs` varchar(255) NOT NULL DEFAULT '',
  `api_post_regcfm` varchar(255) NOT NULL DEFAULT '',
  `api_post_changeuser` varchar(255) NOT NULL DEFAULT '',
  `welcome_screen_on` int(1) NOT NULL DEFAULT '0',
  `welcome_screen` text NOT NULL,
  `admin_dashboard_on` int(1) NOT NULL DEFAULT '0',
  `labelling` text NOT NULL,
  `no_regbutton` int(1) NOT NULL DEFAULT '0',
  `email_log_enabled` int(1) NOT NULL DEFAULT '0',
  `refsale_autocancel_period` int(3) NOT NULL DEFAULT '0',
  `ccupdate_request_intervals` varchar(30) NOT NULL DEFAULT '',
  `ccupdate_notify_admins` varchar(50) NOT NULL DEFAULT '',
  `jvzooipn_secret` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_metaaff` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `aff_selected` varchar(255) NOT NULL DEFAULT '',
  `aff_group` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_order` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `signature` char(8) NOT NULL DEFAULT '',
  `complete` int(1) NOT NULL DEFAULT '0',
  `is_bulk` int(1) NOT NULL DEFAULT '0',
  `aweber_done` int(1) NOT NULL DEFAULT '0',
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `pack_title` varchar(255) NOT NULL DEFAULT '',
  `aff_user_id` int(11) NOT NULL DEFAULT '0',
  `aff_camp_id` varchar(50) NOT NULL DEFAULT '',
  `aff_init_user_id` int(11) NOT NULL DEFAULT '0',
  `aff_curr_user_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_email` varchar(255) NOT NULL,
  `user_fname` varchar(255) NOT NULL,
  `user_lname` varchar(255) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `user_address` varchar(255) NOT NULL DEFAULT '',
  `user_city` varchar(255) NOT NULL DEFAULT '',
  `user_state` varchar(255) NOT NULL DEFAULT '',
  `user_zipcode` varchar(255) NOT NULL DEFAULT '',
  `user_country` varchar(255) NOT NULL DEFAULT '',
  `shipping_address` varchar(255) NOT NULL DEFAULT '',
  `shipping_city` varchar(255) NOT NULL DEFAULT '',
  `shipping_state` varchar(255) NOT NULL DEFAULT '',
  `shipping_zipcode` varchar(255) NOT NULL DEFAULT '',
  `shipping_country` varchar(255) NOT NULL DEFAULT '',
  `user_phone` varchar(255) NOT NULL DEFAULT '',
  `user_company` varchar(255) NOT NULL DEFAULT '',
  `stripe_customer_id` varchar(255) DEFAULT NULL,
  `stripe_payment_method` varchar(255) DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `aff_user_id` (`aff_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_oto` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `descr` longtext NOT NULL,
  `buttons_style` varchar(30) NOT NULL DEFAULT '',
  `yesbtn_title` varchar(255) NOT NULL DEFAULT '',
  `yesbtn_attr` varchar(255) NOT NULL DEFAULT '',
  `nobtn_title` varchar(255) NOT NULL DEFAULT '',
  `nobtn_attr` varchar(255) NOT NULL DEFAULT '',
  `dest_prod_id` int(11) NOT NULL DEFAULT '0',
  `dest_url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_package` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `type` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL DEFAULT '',
  `thankpage` varchar(255) NOT NULL DEFAULT '',
  `altpage` varchar(255) NOT NULL DEFAULT '',
  `locked` int(1) NOT NULL DEFAULT '0',
  `locked_ext` varchar(255) NOT NULL DEFAULT '',
  `squeeze_autoresp_ids` varchar(255) NOT NULL DEFAULT '',
  `sale_autoresp_ids` varchar(255) NOT NULL DEFAULT '',
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `email_welcome` text NOT NULL,
  `aff_prevailing_mode` int(1) NOT NULL DEFAULT '0',
  `affprogs` varchar(255) NOT NULL DEFAULT '',
  `quickresell_affprogs` varchar(255) NOT NULL DEFAULT '',
  `campaigns` varchar(255) NOT NULL DEFAULT '',
  `no_aff_area` int(1) NOT NULL DEFAULT '0',
  `commission_perclick` varchar(50) NOT NULL DEFAULT '',
  `promo_window_width` int(11) NOT NULL DEFAULT '0',
  `promo_window_height` int(11) NOT NULL DEFAULT '0',
  `aff_customtags` varchar(255) NOT NULL DEFAULT '',
  `signature` char(2) NOT NULL DEFAULT '',
  `aweber_yes` int(1) NOT NULL DEFAULT '0',
  `aweber_settings` text NOT NULL,
  `extints` varchar(255) NOT NULL DEFAULT '',
  `abandone_yes` int(1) NOT NULL DEFAULT '0',
  `abandone_waithours` varchar(5) NOT NULL DEFAULT '',
  `abandone_email` text NOT NULL,
  `abandone_fum_id` int(11) NOT NULL DEFAULT '0',
  `pgates` varchar(255) NOT NULL DEFAULT '',
  `backpay_override` int(1) NOT NULL DEFAULT '0',
  `backpay_pgates` varchar(50) NOT NULL DEFAULT '',
  `currency` char(3) NOT NULL,
  `currency_rate` decimal(10,6) NOT NULL DEFAULT '0.000000',
  `hide_prodlist` int(1) NOT NULL DEFAULT '0',
  `bypass` int(1) NOT NULL DEFAULT '0',
  `combo_ty` int(1) NOT NULL DEFAULT '0',
  `html_head` text NOT NULL,
  `html_foot` text NOT NULL,
  `is_customized2` tinyint(1) NOT NULL DEFAULT '0',
  `is_customized` tinyint(1) NOT NULL DEFAULT '0',
  `shipping` int(1) NOT NULL DEFAULT '0',
  `geoforce_enabled` int(1) NOT NULL DEFAULT '0',
  `geoforce_ids` varchar(255) NOT NULL DEFAULT '',
  `geoforce_limited_sales` int(1) NOT NULL DEFAULT '0',
  `invoicepdfs` varchar(255) NOT NULL DEFAULT '',
  `use_terms` int(1) NOT NULL DEFAULT '0',
  `use_terms_url_text` varchar(255) NOT NULL,
  `use_terms_op` tinyint(1) NOT NULL,
  `opt_in` varchar(255) NOT NULL,
  `autoassign_memberships` varchar(255) NOT NULL DEFAULT '',
  `api_post_notifysale` varchar(255) NOT NULL DEFAULT '',
  `api_post_regcfm` varchar(255) NOT NULL DEFAULT '',
  `reflink_disabled` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_package_hit` (
  `tstamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `camp_id` varchar(50) NOT NULL DEFAULT '',
  `aff_user_id` int(11) NOT NULL DEFAULT '0',
  `coo` char(16) NOT NULL,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `pack_id` (`pack_id`,`camp_id`,`coo`),
  KEY `camp_id` (`camp_id`,`aff_user_id`),
  KEY `aff_user_id` (`aff_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_package_hit_ipcache` (
  `tstamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `pack_id` (`pack_id`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_package_product` (
  `prod_id` int(11) NOT NULL,
  `pack_id` int(11) NOT NULL,
  `cat_id` int(11) NOT NULL,
  `upsell` int(1) NOT NULL DEFAULT '0',
  `checked` int(1) NOT NULL DEFAULT '0',
  `tstamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `prod_id` (`prod_id`,`pack_id`,`cat_id`),
  KEY `pack_id` (`pack_id`,`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_page` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `group_title` varchar(255) NOT NULL DEFAULT '',
  `group_tmpl_id` int(11) NOT NULL DEFAULT '0',
  `group_protection` varchar(10) NOT NULL DEFAULT '',
  `group_mems` varchar(255) NOT NULL DEFAULT '',
  `group_menu` text NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `tmpl_id` int(11) NOT NULL DEFAULT '0',
  `protection` varchar(10) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `content` longtext NOT NULL,
  `template` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_paycomm_period` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `next_period_days` int(3) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_paylog` (
  `ctime` datetime DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `pgate_id` int(11) NOT NULL DEFAULT '0',
  `pgate_title` varchar(50) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `order_id` (`order_id`),
  KEY `sale_id` (`sale_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_payplan` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `prod_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `is_flat` int(1) NOT NULL DEFAULT '0',
  `amount` varchar(15) NOT NULL DEFAULT '',
  `period_l` varchar(10) NOT NULL DEFAULT '',
  `period_u` char(1) NOT NULL DEFAULT '',
  `numinst` varchar(10) NOT NULL DEFAULT '',
  `trial_l` varchar(10) NOT NULL DEFAULT '',
  `trial_u` char(1) NOT NULL DEFAULT '',
  `trial_amount` varchar(15) NOT NULL DEFAULT '',
  `shipping` int(1) NOT NULL DEFAULT '0',
  `pgates` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_pgate` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `settings` text NOT NULL,
  `external_ipn` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_pgtxn` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `txn_code` varchar(255) NOT NULL DEFAULT '',
  `processed` int(1) NOT NULL DEFAULT '0',
  `successful` int(1) NOT NULL DEFAULT '0',
  `pgate_id` int(11) NOT NULL DEFAULT '0',
  `pgate_type` varchar(30) NOT NULL DEFAULT '',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`,`sale_id`),
  KEY `txn_code` (`txn_code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_priceinc` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `time_start` time DEFAULT NULL,
  `time_end` time DEFAULT NULL,
  `price_start` decimal(8,2) NOT NULL DEFAULT '0.00',
  `price_end` decimal(8,2) NOT NULL DEFAULT '0.00',
  `incr` varchar(32) NOT NULL DEFAULT '',
  `period_l` int(4) NOT NULL DEFAULT '0',
  `period_u` varchar(15) NOT NULL DEFAULT '',
  `jsflow` int(1) NOT NULL DEFAULT '0',
  `template` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_product` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `label_add` varchar(255) NOT NULL,
  `label_remove` varchar(255) NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  `is_deleted` int(1) NOT NULL DEFAULT '0',
  `jvent_user_id` int(11) NOT NULL DEFAULT '0',
  `jvent_status` varchar(50) NOT NULL DEFAULT '',
  `jvent_commission` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `cost` decimal(8,2) NOT NULL DEFAULT '0.00',
  `payplan_id` int(11) NOT NULL DEFAULT '0',
  `autochecked` int(1) NOT NULL DEFAULT '0',
  `date_availtill` date DEFAULT NULL,
  `time_availtill` time DEFAULT NULL,
  `period_validity` int(11) NOT NULL DEFAULT '0',
  `limit_sales_max` varchar(50) NOT NULL DEFAULT '',
  `limit_sales_done` varchar(50) NOT NULL DEFAULT '',
  `no_renew` int(1) NOT NULL DEFAULT '0',
  `no_cust_salelist` int(1) NOT NULL DEFAULT '0',
  `no_thank_you_email` int(1) NOT NULL DEFAULT '0',
  `non_taxable` int(1) NOT NULL DEFAULT '0',
  `specusers` int(11) NOT NULL DEFAULT '0',
  `specusers_excuse` text NOT NULL,
  `specprice` text NOT NULL,
  `specprices_plan` int(11) NOT NULL DEFAULT '0',
  `multprod_on` int(1) NOT NULL DEFAULT '0',
  `discplan` varchar(255) NOT NULL DEFAULT '',
  `master_memberships` varchar(100) NOT NULL DEFAULT '',
  `embed_prods` varchar(100) NOT NULL DEFAULT '',
  `embed_prods_recur` varchar(100) NOT NULL DEFAULT '',
  `upgrade_prod` int(11) NOT NULL DEFAULT '0',
  `send_cust_login_data` int(1) NOT NULL DEFAULT '0',
  `api_post_notifysale` varchar(255) NOT NULL DEFAULT '',
  `owner_name` varchar(255) NOT NULL DEFAULT '',
  `owner_email` varchar(255) NOT NULL DEFAULT '',
  `aff_prevailing_mode` int(1) NOT NULL DEFAULT '0',
  `commission_aff` varchar(255) NOT NULL DEFAULT '',
  `aff_instcomm_on` int(1) NOT NULL DEFAULT '0',
  `aff_instcomm_percent` int(3) NOT NULL DEFAULT '0',
  `aff_instcomm_order` int(1) NOT NULL DEFAULT '0',
  `aff_instcomm_tstamp` datetime DEFAULT NULL,
  `commission_charity` varchar(255) NOT NULL DEFAULT '',
  `period_guarantee` int(11) NOT NULL DEFAULT '0',
  `period_guarantee_no4recur` int(1) NOT NULL DEFAULT '0',
  `comm_recur_stop` int(3) NOT NULL DEFAULT '0',
  `quickresell_enabled` int(1) NOT NULL DEFAULT '0',
  `quickresell_commission_royalty` varchar(50) NOT NULL DEFAULT '',
  `quickresell_price_min` varchar(10) NOT NULL DEFAULT '',
  `quickresell_price_max` varchar(10) NOT NULL DEFAULT '',
  `quickresell_instructions` text NOT NULL,
  `shopcart_enabled` int(1) NOT NULL DEFAULT '0',
  `shopcart_image_url` varchar(255) NOT NULL DEFAULT '',
  `rating_total` int(11) NOT NULL DEFAULT '0',
  `rating_votes` int(11) NOT NULL DEFAULT '0',
  `rating_last_ip` varchar(50) NOT NULL DEFAULT '',
  `points_obtain_cust` varchar(50) NOT NULL DEFAULT '',
  `points_obtain_cust_recur` int(1) NOT NULL DEFAULT '0',
  `points_obtain_aff` varchar(50) NOT NULL DEFAULT '',
  `points_obtain_aff_recur` int(1) NOT NULL DEFAULT '0',
  `points_price` varchar(50) NOT NULL DEFAULT '',
  `pointscomm_aff` int(1) NOT NULL DEFAULT '0',
  `pointscomm_jvpartner` int(1) NOT NULL DEFAULT '0',
  `shipping_group_id` int(11) NOT NULL DEFAULT '0',
  `dlv_instructions` text NOT NULL,
  `dlv_otos` varchar(255) NOT NULL DEFAULT '',
  `dlv_downloads` varchar(255) NOT NULL DEFAULT '',
  `dlv_downloads_expire` varchar(50) NOT NULL DEFAULT '',
  `dlv_brandpdfs` varchar(255) NOT NULL DEFAULT '',
  `dlv_memberships` varchar(255) NOT NULL DEFAULT '',
  `dlv_roles` varchar(255) NOT NULL DEFAULT '',
  `dlv_affprogs` varchar(255) NOT NULL DEFAULT '',
  `dlv_quests` varchar(255) NOT NULL DEFAULT '',
  `dlv_extscripts` varchar(255) NOT NULL DEFAULT '',
  `dlv_coupons` varchar(255) NOT NULL DEFAULT '',
  `dlv_points` varchar(255) NOT NULL DEFAULT '',
  `dlv_lessonseries` varchar(255) NOT NULL DEFAULT '',
  `dlv_insignia` varchar(255) NOT NULL DEFAULT '',
  `dlv_wplicenses` varchar(255) NOT NULL,
  `pgates` varchar(255) NOT NULL DEFAULT '',
  `extints` varchar(255) NOT NULL DEFAULT '',
  `backpay_override` int(1) NOT NULL DEFAULT '0',
  `backpay_pgates` varchar(50) NOT NULL DEFAULT '',
  `pg_2checkout_pid` varchar(50) NOT NULL DEFAULT '',
  `pg_clickbank_linknumber` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`is_deleted`),
  KEY `payplan_id` (`payplan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_promogen` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT '',
  `seq` int(11) NOT NULL,
  `template` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `instructions` longtext NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` longtext NOT NULL,
  `imageUrl` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_promogen_template` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `template` text NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT '',
  `file` varchar(255) NOT NULL DEFAULT '',
  `is_default` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_quest` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `instructions` text NOT NULL,
  `blocking` int(1) NOT NULL DEFAULT '0',
  `from_customer` int(1) NOT NULL DEFAULT '0',
  `notify_emails` varchar(255) NOT NULL DEFAULT '',
  `notify_create` text NOT NULL,
  `notify_delete` text NOT NULL,
  `api_post_quest` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_quest_item` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `quest_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `mandatory` int(1) NOT NULL DEFAULT '0',
  `type` varchar(30) NOT NULL DEFAULT '',
  `customlist` text NOT NULL,
  `seq` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `quest_id` (`quest_id`,`seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_quickresell` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `aff_id` int(11) NOT NULL DEFAULT '0',
  `prod_id` int(11) NOT NULL DEFAULT '0',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `pgates` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aff_id` (`aff_id`,`prod_id`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_referrer_clicks` (
  `refferer_id` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  `count` int(11) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `IX_UNIQUE` (`refferer_id`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_reflink` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `introduction` text NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `overridden` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`parent_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_reflink_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `limit_for_affiliate` int(11) NOT NULL DEFAULT '0',
  `limit_for_display` int(11) NOT NULL DEFAULT '0',
  `template` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_reminder` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `event_date` datetime DEFAULT NULL,
  `remind_date` datetime DEFAULT NULL,
  `recurring` tinyint(2) NOT NULL DEFAULT '0',
  `recur_until` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_reminder_type` (
  `title` varchar(100) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_reward` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `active` int(1) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT '',
  `notes` text NOT NULL,
  `multiply` int(11) NOT NULL DEFAULT '0',
  `valid_from` date DEFAULT NULL,
  `valid_until` date DEFAULT NULL,
  `cust_all` int(1) NOT NULL DEFAULT '0',
  `cust_selected` varchar(255) NOT NULL DEFAULT '',
  `cust_existing` int(1) NOT NULL DEFAULT '0',
  `cust_existing_since` date DEFAULT NULL,
  `cust_existing_pack` varchar(255) NOT NULL DEFAULT '',
  `cust_existing_prod` varchar(255) NOT NULL DEFAULT '',
  `cust_new` int(1) NOT NULL DEFAULT '0',
  `cust_new_pack` varchar(255) NOT NULL DEFAULT '',
  `cust_new_prod` varchar(255) NOT NULL DEFAULT '',
  `cust_paid_min` varchar(20) NOT NULL DEFAULT '',
  `cust_paid_max` varchar(20) NOT NULL DEFAULT '',
  `aff_all` int(1) NOT NULL DEFAULT '0',
  `aff_selected` varchar(255) NOT NULL DEFAULT '',
  `aff_group` varchar(255) NOT NULL DEFAULT '',
  `aff_registered_after` date DEFAULT NULL,
  `aff_generate_min` varchar(20) NOT NULL DEFAULT '',
  `aff_generate_max` varchar(20) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_role` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `needapproval` int(1) NOT NULL DEFAULT '0',
  `enhanced_mode` int(1) NOT NULL DEFAULT '0',
  `priv_hosted_account` int(1) NOT NULL,
  `priv_supervisor` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_login` tinyint(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_merchant` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_smtpservers` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_apicenter` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_security` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_member` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_pgates` int(1) NOT NULL DEFAULT '0',
  `priv_auth_profile_affpgates` int(1) NOT NULL DEFAULT '0',
  `priv_master_store_packages` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_products` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_funnels` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_oneclickords` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_minisites` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_jvproducts` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_specprices` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_shopcarts` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_otos` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_downloads` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_brandpdfs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_memberships` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_quests` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_extints` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_extscripts` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_taxes` varchar(50) NOT NULL DEFAULT '',
  `priv_master_store_shippings` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_sales` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_jvmsubs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_actsubs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_memberships` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_quests` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_extscripts` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_shipdue` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_tracklinks` varchar(50) NOT NULL DEFAULT '',
  `priv_master_customers_wplicenses` varchar(50) NOT NULL,
  `priv_master_affiliates_users` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_affprogs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_campaigns` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_series` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_commissions` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_paycomms` varchar(50) NOT NULL DEFAULT '',
  `priv_master_affiliates_royalties` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_all` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_massmail` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_massuserop` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_roles` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_specusers` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_customfields` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_downlines` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_import` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_invite` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_approve` varchar(50) NOT NULL DEFAULT '',
  `priv_master_users_insignia` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_stats` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_templates` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_emails` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_customtags` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_forms` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_bans` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_coupons` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_rewards` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_shorturls` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_export` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_pieces` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_dbbackup` varchar(50) NOT NULL DEFAULT '',
  `priv_master_tools_satelliteinstallations` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_invoicepdfs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_promogen` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_sponsorships` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_supros` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_banners` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_linkdirs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_alerts` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_testimonials` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_followupman` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_jvevents` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_syevents` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_affinbs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_pages` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_geoforce` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_blogpub` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_bcastnews` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_certman` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_clouds` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_multrec` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_reminders` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_helptickets` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_metaaffs` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_contseries` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_lessonman` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_surveys` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_trackurls` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_ezinepoints` varchar(50) NOT NULL DEFAULT '',
  `priv_master_plugins_wplicenses` varchar(255) NOT NULL,
  `priv_member_account_purchases` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_mems` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_jvmsubs` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_ccupdate` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_points` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_helptickets` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_backlink` varchar(50) NOT NULL DEFAULT '',
  `priv_member_account_surveys` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_dashboard` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_affprogs` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_links` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_campaigns` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_sales` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_commissions` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_jvproducts` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_royalties` varchar(50) NOT NULL DEFAULT '',
  `priv_member_promote_payroyalties` varchar(50) NOT NULL DEFAULT '',
  `priv_member_downline_view` varchar(50) NOT NULL DEFAULT '',
  `priv_member_downline_massmail` varchar(50) NOT NULL DEFAULT '',
  `priv_member_downline_commissions` varchar(50) NOT NULL DEFAULT '',
  `priv_member_downline_refer` varchar(50) NOT NULL DEFAULT '',
  `priv_spec_maildownlinenofooter` int(1) NOT NULL DEFAULT '0',
  `priv_spec_yourcommissionseecustomer` int(1) NOT NULL DEFAULT '0',
  `priv_spec_yourcommissionseezero` int(1) NOT NULL DEFAULT '0',
  `priv_spec_autoresowncust` int(1) NOT NULL DEFAULT '0',
  `priv_spec_autoresrefcust` int(1) NOT NULL DEFAULT '0',
  `limit_massmailnumber` varchar(50) NOT NULL DEFAULT '',
  `limit_massmailperiod` varchar(50) NOT NULL DEFAULT '',
  `limit_memberships` varchar(50) NOT NULL DEFAULT '',
  `limit_labels` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_sale` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `tstamp_date` date DEFAULT NULL,
  `ctime` datetime DEFAULT NULL,
  `signature` char(8) NOT NULL DEFAULT '',
  `descr` varchar(255) NOT NULL DEFAULT '',
  `amount` varchar(50) NOT NULL,
  `amount_prod` varchar(50) NOT NULL DEFAULT '',
  `amount_discount` varchar(50) NOT NULL DEFAULT '',
  `amount_tax_pc` varchar(50) NOT NULL DEFAULT '',
  `amount_tax_embed` int(1) NOT NULL DEFAULT '0',
  `amount_tax` varchar(50) NOT NULL DEFAULT '',
  `amount_shipping` varchar(50) NOT NULL DEFAULT '',
  `amount_comms` varchar(50) NOT NULL DEFAULT '',
  `has_comms` int(1) NOT NULL DEFAULT '0',
  `currency` char(3) NOT NULL,
  `currency_rate` decimal(10,6) NOT NULL DEFAULT '0.000000',
  `prod_id` int(11) NOT NULL DEFAULT '0',
  `prod_title` varchar(150) NOT NULL DEFAULT '',
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `pack_title` varchar(150) NOT NULL DEFAULT '',
  `funnel_step_id` int(11) NOT NULL DEFAULT '0',
  `funnel_step_title` varchar(150) NOT NULL DEFAULT '',
  `funnel_splitpage_id` int(11) NOT NULL DEFAULT '0',
  `numprod` int(11) NOT NULL DEFAULT '0',
  `paid` int(1) NOT NULL DEFAULT '0',
  `txn_pgate_type` varchar(30) NOT NULL DEFAULT '',
  `txn_pgate_id` int(11) NOT NULL DEFAULT '0',
  `txn_code` varchar(32) NOT NULL DEFAULT '',
  `txn_waiting` int(1) NOT NULL DEFAULT '0',
  `txn_return_url` varchar(255) NOT NULL DEFAULT '',
  `ccs_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `aff_user_id` int(11) NOT NULL DEFAULT '0',
  `aff_camp_id` varchar(50) NOT NULL DEFAULT '',
  `metaaff_id` int(11) NOT NULL DEFAULT '0',
  `tracklink_id` int(11) NOT NULL DEFAULT '0',
  `container_sale_id` int(11) NOT NULL DEFAULT '0',
  `old_sale_id` int(11) NOT NULL DEFAULT '0',
  `refund_deadline` date DEFAULT NULL,
  `refunded` int(1) NOT NULL DEFAULT '0',
  `remote_ip` varchar(32) NOT NULL DEFAULT '',
  `is_subscr` int(1) NOT NULL DEFAULT '0',
  `subscr_id` varchar(50) NOT NULL DEFAULT '',
  `subscr_not_initial` int(1) NOT NULL DEFAULT '0',
  `subscr_inst_number` int(11) NOT NULL DEFAULT '0',
  `subscr_amount` varchar(50) NOT NULL DEFAULT '',
  `subscr_amount_prod` varchar(50) NOT NULL DEFAULT '',
  `no_renew` int(1) NOT NULL DEFAULT '0',
  `no_cust_salelist` int(1) NOT NULL DEFAULT '0',
  `oto_shown` int(11) NOT NULL DEFAULT '0',
  `is_quickresell` int(1) NOT NULL DEFAULT '0',
  `is_instcomm` int(1) NOT NULL DEFAULT '0',
  `download_ctime` datetime DEFAULT NULL,
  `coupon_mode` int(1) NOT NULL DEFAULT '0',
  `coupon_code` char(16) NOT NULL DEFAULT '0',
  `coupon_discount` varchar(50) NOT NULL DEFAULT '',
  `points_cashed` varchar(50) NOT NULL DEFAULT '',
  `points_earned` varchar(50) NOT NULL DEFAULT '',
  `shipping_id` int(11) NOT NULL DEFAULT '0',
  `shipping_subid` varchar(255) NOT NULL DEFAULT '',
  `shipping_recur` int(1) NOT NULL DEFAULT '0',
  `specprice_descr` varchar(100) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `subscr_id` (`subscr_id`),
  KEY `order_id` (`order_id`),
  KEY `user_id` (`user_id`),
  KEY `aff_user_id` (`aff_user_id`),
  KEY `txn_code` (`txn_code`),
  KEY `aff_camp_id` (`aff_camp_id`,`paid`),
  KEY `tracklink_id` (`tracklink_id`,`paid`),
  KEY `prod_id` (`prod_id`),
  KEY `pack_id` (`pack_id`),
  KEY `funnel_step_id` (`funnel_step_id`),
  KEY `container_sale_id` (`container_sale_id`),
  KEY `paid` (`paid`),
  KEY `tstamp_date` (`tstamp_date`,`paid`),
  KEY `ccs_id` (`ccs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_satellite_installation` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `url` varchar(50) NOT NULL DEFAULT '',
  `admin_email` varchar(255) NOT NULL DEFAULT '',
  `admin_passwd` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shipping` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `settings` text NOT NULL,
  `email_status` text NOT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shipping_due` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `shipping_id` int(11) NOT NULL,
  `descr` varchar(255) NOT NULL DEFAULT '',
  `fulfilled` int(1) NOT NULL DEFAULT '0',
  `procid` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sale_id` (`sale_id`),
  KEY `fulfilled` (`fulfilled`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shipping_group` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '',
  `prioritized` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shopcart_category` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `pack_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `seq` int(11) NOT NULL,
  `path_id` varchar(255) NOT NULL DEFAULT '',
  `path_seq` varchar(255) NOT NULL DEFAULT '',
  `level` int(11) NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pack_id` (`pack_id`,`parent_id`),
  KEY `pack_id_2` (`pack_id`,`path_seq`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shopcart_review` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `prod_id` int(11) NOT NULL DEFAULT '0',
  `approved` int(1) NOT NULL DEFAULT '0',
  `pdate` datetime DEFAULT NULL,
  `message` text NOT NULL,
  `author_name` varchar(50) NOT NULL DEFAULT '',
  `author_email` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `prod_id` (`prod_id`,`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_shopcart_settings` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `pack_id` int(11) NOT NULL DEFAULT '0',
  `review_moderation` int(1) NOT NULL DEFAULT '0',
  `review_pagesize` int(11) NOT NULL DEFAULT '0',
  `catalog_img_width` int(11) NOT NULL DEFAULT '0',
  `catalog_pagesize` int(11) NOT NULL DEFAULT '0',
  `prodinfo_img_width` int(11) NOT NULL DEFAULT '0',
  `gallery_img_height` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pack_id` (`pack_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_short_url` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `ref_obj_type` varchar(15) NOT NULL DEFAULT '',
  `ref_obj_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ref_obj_type` (`ref_obj_type`,`ref_obj_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_skip_branch_condition` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `scope_type` varchar(15) NOT NULL DEFAULT '',
  `scope_id` int(11) NOT NULL DEFAULT '0',
  `ord` int(3) NOT NULL DEFAULT '0',
  `cond_type` varchar(10) NOT NULL DEFAULT '',
  `cond_obj_id` int(11) NOT NULL DEFAULT '0',
  `action` varchar(10) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `scope_type` (`scope_type`,`scope_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_smtp_server` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `smtp_server` varchar(100) NOT NULL DEFAULT '',
  `port` int(5) NOT NULL DEFAULT '25',
  `auth_user` varchar(50) NOT NULL DEFAULT '',
  `auth_pass` varchar(50) NOT NULL DEFAULT '',
  `active` int(1) NOT NULL DEFAULT '0',
  `tls` tinyint(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `active` (`active`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_specprices` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `settings` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_specusers` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `notes` text NOT NULL,
  `u_all` int(1) NOT NULL DEFAULT '0',
  `u_selected` varchar(255) NOT NULL DEFAULT '',
  `u_since` date DEFAULT NULL,
  `u_cust_new` int(1) NOT NULL DEFAULT '0',
  `u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `u_roles` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_roles` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_roles` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_roles` varchar(255) NOT NULL DEFAULT '',
  `u_memberships` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_memberships` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_memberships` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_memberships` varchar(255) NOT NULL DEFAULT '',
  `u_insignia` varchar(255) NOT NULL DEFAULT '',
  `f_cond_and__u_insignia` varchar(255) NOT NULL DEFAULT '',
  `f_cond_or__u_insignia` varchar(255) NOT NULL DEFAULT '',
  `f_cond_not__u_insignia` varchar(255) NOT NULL DEFAULT '',
  `u_surveys` varchar(255) NOT NULL DEFAULT '',
  `u_paid_min` varchar(20) NOT NULL DEFAULT '',
  `u_paid_max` varchar(20) NOT NULL DEFAULT '',
  `u_generated_min` varchar(20) NOT NULL DEFAULT '',
  `u_generated_max` varchar(20) NOT NULL DEFAULT '',
  `u_count_sales_from` date DEFAULT NULL,
  `u_count_sales_until` date DEFAULT NULL,
  `remote_delavo_api_url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_specusers_filters` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IX_UNIQUE` (`name`,`parent`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_sponsor` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `expire` date DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_sponsor_cfg` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `orderurl` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_stats_report` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(16) NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `search` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `signature` (`signature`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_style` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `width` varchar(30) NOT NULL DEFAULT '',
  `bgcolor` varchar(30) NOT NULL DEFAULT '',
  `font_color` varchar(30) NOT NULL DEFAULT '',
  `font_style` varchar(30) NOT NULL DEFAULT '',
  `font_size` varchar(30) NOT NULL DEFAULT '',
  `css_class` varchar(50) NOT NULL DEFAULT '',
  `css_style` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_supro` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `limit_ips` int(6) NOT NULL DEFAULT '0',
  `limit_ips_user` int(6) NOT NULL DEFAULT '0',
  `limit_downloads` int(6) NOT NULL DEFAULT '0',
  `limit_downloads_user` int(6) NOT NULL DEFAULT '0',
  `limit_referer` text NOT NULL,
  `expires` date DEFAULT NULL,
  `admin_notes` text NOT NULL,
  `denied_template` int(11) NOT NULL DEFAULT '0',
  `u_all` int(1) NOT NULL DEFAULT '0',
  `u_selected` varchar(255) NOT NULL DEFAULT '',
  `u_since` date DEFAULT NULL,
  `u_cust_new` int(1) NOT NULL DEFAULT '0',
  `u_cust_packs` varchar(255) NOT NULL DEFAULT '',
  `u_cust_prods` varchar(255) NOT NULL DEFAULT '',
  `u_affprogs` varchar(255) NOT NULL DEFAULT '',
  `u_roles` varchar(255) NOT NULL DEFAULT '',
  `u_memberships` varchar(255) NOT NULL DEFAULT '',
  `u_insignia` varchar(255) NOT NULL DEFAULT '',
  `u_surveys` varchar(255) NOT NULL DEFAULT '',
  `u_paid_min` varchar(20) NOT NULL DEFAULT '',
  `u_paid_max` varchar(20) NOT NULL DEFAULT '',
  `u_generated_min` varchar(20) NOT NULL DEFAULT '',
  `u_generated_max` varchar(20) NOT NULL DEFAULT '',
  `u_count_sales_from` date DEFAULT NULL,
  `u_count_sales_until` date DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_supro_stat` (
  `supro_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `ip` varchar(32) NOT NULL DEFAULT '',
  `referer` varchar(255) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `user_email` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `supro_id` (`supro_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_survey` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `user_acl` varchar(255) NOT NULL DEFAULT '',
  `intro_html` text NOT NULL,
  `return_url` varchar(255) NOT NULL DEFAULT '',
  `return_html` text NOT NULL,
  `password` varchar(50) NOT NULL DEFAULT '',
  `use_captcha` int(1) NOT NULL DEFAULT '0',
  `archive_after` int(4) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_survey_data` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `survey_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `page_completed` int(2) NOT NULL DEFAULT '0',
  `archived` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `survey_id` (`survey_id`),
  KEY `archived` (`archived`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_survey_data_big` (
  `data_id` int(11) NOT NULL DEFAULT '0',
  `question_id` int(11) NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  `seq` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `data_id` (`data_id`,`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_survey_data_small` (
  `data_id` int(11) NOT NULL DEFAULT '0',
  `question_id` int(11) NOT NULL DEFAULT '0',
  `answer` varchar(255) NOT NULL DEFAULT '',
  `seq` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `data_id` (`data_id`,`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_survey_question` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `survey_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `seq` int(3) NOT NULL DEFAULT '0',
  `pagebreak` int(1) NOT NULL DEFAULT '0',
  `required` int(1) NOT NULL DEFAULT '0',
  `selector_data` text NOT NULL,
  `selector_type` varchar(30) NOT NULL DEFAULT '',
  `text_enabled` int(1) NOT NULL DEFAULT '0',
  `text_type` varchar(30) NOT NULL DEFAULT '',
  `text_caption` varchar(255) NOT NULL DEFAULT '',
  `text_is_big` int(1) NOT NULL DEFAULT '0',
  `intro_html` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `survey_id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_syevent` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `membership_id` int(11) NOT NULL DEFAULT '0',
  `pagesize` int(3) NOT NULL DEFAULT '0',
  `period_validity` int(11) NOT NULL DEFAULT '0',
  `max_image_size` int(6) NOT NULL DEFAULT '0',
  `max_download_size` int(6) NOT NULL DEFAULT '0',
  `template_list` longtext NOT NULL,
  `template_submit` longtext NOT NULL,
  `style_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `signature` (`signature`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_syevent_prod` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `ctime` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `syevent_id` int(11) NOT NULL DEFAULT '0',
  `approved` int(1) NOT NULL DEFAULT '0',
  `sortdate` datetime DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `price` varchar(30) NOT NULL DEFAULT '',
  `cover_url` varchar(255) NOT NULL DEFAULT '',
  `download_url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `syevent_id` (`syevent_id`,`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_syo_prod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `signature` char(8) NOT NULL DEFAULT '',
  `ctime` datetime DEFAULT NULL,
  `syo_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `approved` int(1) NOT NULL DEFAULT '0',
  `sortdate` datetime DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descr` text NOT NULL,
  `price` varchar(30) NOT NULL DEFAULT '',
  `cover_url` varchar(255) NOT NULL DEFAULT '',
  `download_url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `syo_id` (`syo_id`,`approved`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_syslog` (
  `ctime` datetime DEFAULT NULL,
  `seq` int(11) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `message` varchar(255) NOT NULL DEFAULT '',
  `type` char(1) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_sys_alert` (
  `tstamp` datetime DEFAULT NULL,
  `expires` datetime DEFAULT NULL,
  `code` varchar(50) NOT NULL DEFAULT '',
  `value` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_tax` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `percent` decimal(4,2) NOT NULL DEFAULT '0.00',
  `embedded` int(1) NOT NULL DEFAULT '0',
  `country` varchar(50) NOT NULL DEFAULT '',
  `state` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_template` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL,
  `group_type` varchar(30) NOT NULL DEFAULT '',
  `group_title` varchar(255) NOT NULL DEFAULT '',
  `group_active` int(1) NOT NULL DEFAULT '0',
  `group_skin` varchar(50) NOT NULL DEFAULT '',
  `tmpl_type` varchar(30) NOT NULL DEFAULT '',
  `scope` varchar(30) NOT NULL DEFAULT '',
  `html_head` text NOT NULL,
  `body_attr` varchar(255) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `precedence` int(1) NOT NULL DEFAULT '0',
  `compiled` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`,`group_type`),
  KEY `group_id` (`group_id`),
  KEY `group_active` (`group_active`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_terms` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `terms` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_testimonial` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `approved` int(1) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `tag` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(30) NOT NULL DEFAULT '',
  `website_title` varchar(255) NOT NULL DEFAULT '',
  `website_url` varchar(255) NOT NULL DEFAULT '',
  `testimonial` text NOT NULL,
  `videofile` varchar(30) NOT NULL DEFAULT '',
  `player` varchar(30) NOT NULL DEFAULT '',
  `youtube_id` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`,`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_testimonial_page` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL DEFAULT '',
  `add_code` varchar(255) NOT NULL DEFAULT '',
  `ipp` int(11) NOT NULL DEFAULT '0',
  `photo_width` int(11) NOT NULL DEFAULT '0',
  `template` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_texts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_text_revision` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `obj_type` varchar(15) NOT NULL DEFAULT '',
  `obj_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `obj_type` (`obj_type`,`obj_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_theme` (
  `tmpl_code` varchar(50) NOT NULL DEFAULT '',
  `theme` varchar(20) NOT NULL DEFAULT '',
  `html_head` text NOT NULL,
  `html_foot` text,
  `body_attr` varchar(255) NOT NULL DEFAULT '',
  `template` longtext NOT NULL,
  `use_wysiwyg` int(1) NOT NULL DEFAULT '0',
  `orig_theme` varchar(150) NOT NULL DEFAULT '',
  `custom_s1` varchar(30) NOT NULL DEFAULT '',
  `custom_v1` varchar(255) NOT NULL DEFAULT '',
  `custom_v2` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `tmpl_code` (`tmpl_code`,`theme`),
  KEY `theme` (`theme`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_theme_compiled` (
  `tmpl_code` varchar(50) NOT NULL DEFAULT '',
  `theme` varchar(20) NOT NULL DEFAULT '',
  `precedence` int(1) NOT NULL DEFAULT '0',
  `html_head_comp` text NOT NULL,
  `html_foot_comp` text,
  `body_attr` varchar(255) NOT NULL DEFAULT '',
  `template_comp` longtext NOT NULL,
  `custom_packed` text NOT NULL,
  `real_theme` varchar(50) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `tmpl_code` (`tmpl_code`,`theme`),
  KEY `theme` (`theme`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_theme_meta` (
  `tmpl_type` varchar(15) NOT NULL DEFAULT '',
  `theme` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `tmpl_type` (`tmpl_type`,`theme`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_trackable_url` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `page` longtext NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `orders` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_trackable_url_order` (
  `trackurl_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`trackurl_id`,`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_tracking_link` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(70) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `uvisits` int(11) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `label` varchar(255) NOT NULL DEFAULT '',
  `signature` char(16) NOT NULL,
  `registered` int(1) NOT NULL DEFAULT '0',
  `referer_id` int(11) NOT NULL DEFAULT '0',
  `syevent_id` int(11) NOT NULL DEFAULT '0',
  `regtime` datetime DEFAULT NULL,
  `sestime` datetime DEFAULT NULL,
  `reg_ip` varchar(32) NOT NULL DEFAULT '',
  `lastlog_ip` varchar(32) NOT NULL DEFAULT '',
  `points` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `passwd` varchar(255) NOT NULL,
  `passwd_md5` varchar(32) NOT NULL,
  `fname` varchar(255) NOT NULL DEFAULT '',
  `lname` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `address` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(255) NOT NULL DEFAULT '',
  `zipcode` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(255) NOT NULL DEFAULT '',
  `shipping_address` varchar(255) NOT NULL DEFAULT '',
  `shipping_city` varchar(255) NOT NULL DEFAULT '',
  `shipping_state` varchar(255) NOT NULL DEFAULT '',
  `shipping_zipcode` varchar(255) NOT NULL DEFAULT '',
  `shipping_country` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `company` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) NOT NULL DEFAULT '',
  `checks` varchar(255) NOT NULL DEFAULT '',
  `tax_id` varchar(255) NOT NULL DEFAULT '',
  `pg_paypal_email` varchar(255) NOT NULL DEFAULT '',
  `cb_aff_id` varchar(150) NOT NULL DEFAULT '',
  `no_admin_mail` int(1) NOT NULL DEFAULT '0',
  `no_upline_mail` int(1) NOT NULL DEFAULT '0',
  `receive_sms` tinyint(1) NOT NULL DEFAULT '0',
  `get_alerts` tinyint(1) NOT NULL DEFAULT '0',
  `adminlink_tstamp` datetime DEFAULT NULL,
  `adminlink_html` varchar(255) NOT NULL DEFAULT '',
  `admin_notes` text NOT NULL,
  `tracklink_id` int(11) NOT NULL DEFAULT '0',
  `ext_id` int(11) NOT NULL DEFAULT '0',
  `paypal_adaptpay_link` varchar(255) NOT NULL DEFAULT '',
  `access_by_dt` tinyint(1) DEFAULT NULL,
  `access_dt_from` datetime DEFAULT NULL,
  `access_dt_till` datetime DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `reg_ip` (`reg_ip`),
  KEY `signature` (`signature`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_affprog` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `affprog_id` int(11) NOT NULL,
  `affprog_title` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `expires` date DEFAULT NULL,
  `expired` int(1) NOT NULL DEFAULT '0',
  `notapproved` int(1) NOT NULL DEFAULT '0',
  `comment` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `affprog_id` (`affprog_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_custom_field` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `custom_field2` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_dlv` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `ctime` datetime DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `obj_id` int(11) NOT NULL,
  `obj_title` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `expires` date DEFAULT NULL,
  `expired` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`obj_id`),
  KEY `user_id` (`user_id`),
  KEY `sale_id` (`sale_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_email_log` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `tstamp` datetime DEFAULT NULL,
  `method` varchar(30) NOT NULL DEFAULT '',
  `from_string` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `attachments` text NOT NULL,
  `attr` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_point_history` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `otime` datetime DEFAULT NULL,
  `points_before` int(11) NOT NULL,
  `points_after` int(11) NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_quest` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `quest_id` int(11) NOT NULL,
  `expires` date DEFAULT NULL,
  `expired` int(1) NOT NULL DEFAULT '0',
  `userinput` text NOT NULL,
  `triggerdata` text NOT NULL,
  `complete` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `sale_id` (`sale_id`),
  KEY `quest_id` (`quest_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_user_role` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL,
  `role_title` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL DEFAULT '0',
  `expires` date DEFAULT NULL,
  `expired` int(1) NOT NULL DEFAULT '0',
  `notapproved` int(1) NOT NULL DEFAULT '0',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`),
  KEY `sale_id` (`sale_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_video` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '',
  `player` varchar(30) NOT NULL DEFAULT '',
  `youtube_id` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `owner_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_wplicense` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `plugin_name` varchar(255) NOT NULL,
  `owner_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `jin_wplicense_item` (
  `id` int(11) NOT NULL,
  `orig_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `wplicense_id` int(11) NOT NULL,
  `domain` varchar(50) NOT NULL,
  `is_cancelled` tinyint(1) DEFAULT NULL,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


ALTER TABLE `jin_product` ADD FULLTEXT KEY `title` (`title`,`descr`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
