/* 
        MINIMA ATK Linkers control elements
*/
/*
The library "Simple AJAX Code-Kit (SACK) v1.6.1" from module "/kit.zen/suppl/ajax/ajax.js" is used.
*/

	var atkLinkers = new Array();
	
	var atkMsgAdd;
	var atkMsgSLinkerNA;
	if (! atkMsgAdd) atkMsgAdd = 'add';
	if (! atkMsgSLinkerNA) atkMsgSLinkerNA = 'N/A';

	//-----------------------------------------------------
	// atkItem object constructor. Item has value and title
	//-----------------------------------------------------
	function atkItem(value, title)
	{
		this.value = value;
		this.title = title;
	}


	//-----------------------------------------------------
	// registers object as linker
	//-----------------------------------------------------
	function atkRegisterLinker(obj)
	{
		var i = atkLinkers.length;
		if (i == 0) i++;
		atkLinkers[i] = obj;
		return i;
	}


	//-----------------------------------------------------
	// gets registered linker object
	//-----------------------------------------------------
	function atkLinker(id)
	{
		return atkLinkers[id];
	}


	//-----------------------------------------------------
	// atkSLinker object
	//-----------------------------------------------------

	//-----------------------------------------------------
	// atkSLinker (single-item linker) constructor
	//-----------------------------------------------------
	function atkSLinker(field, selectorUrl)
	{
		this.selectorUrl = selectorUrl;
		this.selectorUrl += (selectorUrl.indexOf('?') == -1) ? "?" : "&";
		this.selectorUrl += 'js_autoclose=1';
		
		this.field = field;
		
		this.emptyItem = new atkItem('', atkMsgSLinkerNA);
		this.item = this.emptyItem;
		
		this.makeHTML = atkSlMakeHTML;
		this.setItem = atkSlSetItem;
		this.showSelector = atkSlShowSelector;
		
		// control interface
		this.receive = atkSlReceive;
		this.reset = atkSlReset;
		this.setValue = atkSlSetValue;
		this.setTitle = atkSlSetTitle;
		
		this.id = atkRegisterLinker(this);
		
		this.domId = "control" + this.id;
		this.bindedFieldId = "bindedField" + this.id;
		this.bindedTitleId = "bindedTitle" + this.id;
	}

	//-----------------------------------------------------
	// atkSLinker method: return HTML code for the control
	//-----------------------------------------------------
	function atkSlMakeHTML(targetDiv)
	{
		var code = '<div id="'+ this.domId +'">\n';
		code += '<input id="' + this.bindedFieldId + '" type="hidden" name="' + this.field + '" value="'+ this.item.value +'">\n';
		code += '<span id="' + this.bindedTitleId +'">' + this.item.title + '</span>&nbsp;&nbsp;&nbsp;';
		code += '<a href="#" onClick="atkLinker(' + this.id + ').showSelector(); return false;" title="select"><img src="#{THIS}/linkers_select.gif" align=right vspace=0 hspace=0 border="0" alt="select"></a>';
		code += '<a href="#" onClick="atkLinker(' + this.id + ').reset(); return false;" title="delete"><img src="#{THIS}/linkers_clean.gif" align=right vspace=0 hspace=0 border="0" alt="delete"></a>';
		code += '</div>\n';
		if (targetDiv)
			targetDiv.innerHTML += code;
		else
			document.writeln(code);
	}

	//-----------------------------------------------------
	// atkSLinker method: set item
	//-----------------------------------------------------
	function atkSlSetItem(item)
	{
		if (this.item.value != item.value)
		{
			this.setValue(item.value);
			this.setTitle(item.title + (item.value ? ('&nbsp;(#' + item.value + ')') : ''));
		}
		this.item = item;
	}

	//-----------------------------------------------------
	// atkSLinker method: show external selector window
	//-----------------------------------------------------
	function atkSlShowSelector(f_cond, f_parent, f_title) 
	{
		var eurl;
		eval ("eurl='" + this.selectorUrl + "';"); //     URL  JavaScript
		eurl += (eurl.indexOf('?') == -1) ? "?" : "&";
		eurl += 'js_receiver=' + this.id;
		f_cond ? eurl += '&type=' + f_cond : '';
		f_parent ? eurl += '&parent=' + f_parent : '';
		f_title ? eurl += '&title=' + f_title : '';
		
		var wnd = window.open(eurl, 'Selector' + this.id,'menubar=no,resizable=yes,toolbar=no,location=no,scrollbars=yes,status=yes,width=750,height=550');
		wnd.focus();
		return false;
	}

	//-----------------------------------------------------
	// atkSLinker method: implements receiver interface
	//-----------------------------------------------------
	function atkSlReceive(value, title)
	{
		this.setItem(new atkItem(value, title));
	}

	//-----------------------------------------------------
	// atkSLinker method: reset control binded field
	//-----------------------------------------------------
	function atkSlReset()
	{
		this.setItem(this.emptyItem);
	}

	//-----------------------------------------------------
	// atkSLinker method: set value to control binded field
	//-----------------------------------------------------
	function atkSlSetValue(value)
	{
		var bindedField = document.getElementById(this.bindedFieldId);
		bindedField.value = value;
	}

	//-----------------------------------------------------
	// atkSLinker method: set title to control binded title
	//-----------------------------------------------------
	function atkSlSetTitle(title)
	{
		var bindedTitle = document.getElementById(this.bindedTitleId);
		bindedTitle.innerHTML = title;
	}


	//-----------------------------------------------------
	// atkMLinker (multi-item linker) constructor
	//-----------------------------------------------------
	function atkMLinker(field, selectorUrl)
	{
		this.selectorUrl = selectorUrl;
		
		this.field = field;
		this.items = new Array();
		
		this.makeHTML = atkMlMakeHTML;
		this.makeItem = atkMlMakeItem;
		this.makeAdder = atkMlMakeAdder;
		this.existsItem = atkMlExistsItem;
		this.receive = atkMlReceive;
		this.appendItem = atkMlAppendItem;
		this.appendAdder = atkMlAppendAdder;
		this.removeItem = atkMlRemoveItem;
		this.removeAdder = atkMlRemoveAdder;
		this.rebuildValue = atkMlRebuildValue;
		// inherited from SLinker:
		this.showSelector = atkSlShowSelector;
		this.setValue = atkSlSetValue;  
		
		this.id = atkRegisterLinker(this);
		
		this.domId = "control" + this.id;
		this.bindedFieldId = "bindedField" + this.id;
	}

	//-----------------------------------------------------
	// MLinker method: returns HTML code for empty control 
	//-----------------------------------------------------
	function atkMlMakeHTML(targetDiv)  //   - html;      receive()
	{
		var code = '<div id="' + this.domId + '"><input type="hidden"  id="' + this.bindedFieldId + '" name="'+ this.field + '" value=""></div>\n';
		if (targetDiv)
			targetDiv.innerHTML += code;
		else
			document.writeln(code);
		this.appendAdder();
	}

	//-----------------------------------------------------
	// MLinker method: returns HTML code for an item view by its index
	//-----------------------------------------------------
	function atkMlMakeItem(i)
	{
		return '<a href="#" onClick="atkLinker('+ this.id +').removeItem('+ i +'); return false;" title="delete"><img src="#{THIS}/linkers_clean.gif" border="0"></a>&nbsp;' + this.items[i].title +'&nbsp;(' + this.items[i].value  + ')';
	}

	//-----------------------------------------------------
	// MLinker method: returns HTML code for adder
	//-----------------------------------------------------
	function atkMlMakeAdder()
	{
		return '<a href="#" onClick="atkLinker('+ this.id +').showSelector(); return false;" title="select"><img src="#{THIS}/linkers_add.gif" border="0" alt="add"></a>&nbsp;<a href="#" onClick="atkLinker('+ this.id +').showSelector(); return false;">' + atkMsgAdd + '</a>';
	}

	//-----------------------------------------------------
	// MLinker method: checks if item presents in the items list
	//-----------------------------------------------------
	function atkMlExistsItem(item)
	{
		for (i = 0; i < this.items.length; i++) {
			if (this.items[i].value == item.value) return true;
		}
		return false;
	}

	//-----------------------------------------------------
	// MLinker method: alias for atkMlAppendItem
	//-----------------------------------------------------
	function atkMlReceive(value, title)
	{
		return this.appendItem(new atkItem(value, title));
	}

	//-----------------------------------------------------
	// MLinker method: appends item to the end of the items list
	//-----------------------------------------------------
	function atkMlAppendItem(item)
	{
		if ( this.existsItem(item) ) return false;
		
		var pos = this.items.length;
		this.items.length++;
		this.items[pos] = item;
		
		this.removeAdder();
		
		var items = document.getElementById(this.domId);
		var newItem = document.createElement("div");
		newItem.id = this.domId + 'Item' + pos;
		newItem.innerHTML = this.makeItem(pos);
		items.appendChild(newItem);
		
		this.appendAdder();
		
		this.rebuildValue();
		return false;
	}

	//-----------------------------------------------------
	// MLinker method: appends adder to the end of the items list
	//-----------------------------------------------------
	function atkMlAppendAdder(item)
	{
		var items = document.getElementById(this.domId);
		var adder = document.createElement("div");
		adder.id = this.domId + 'Adder';
		adder.innerHTML = this.makeAdder();
		items.appendChild(adder);
	}

	//-----------------------------------------------------
	// MLinker method: removes item from the items list
	//-----------------------------------------------------
	function atkMlRemoveItem(i)
	{
		var items = document.getElementById(this.domId);
		var item = document.getElementById(this.domId + 'Item' + i);
		items.removeChild(item);
		
		for (k = i; k < this.items.length - 1; k++)
		{
			this.items[k] = this.items[k + 1];
		}
		
		this.items.length--;
		this.rebuildValue();
	}

	//-----------------------------------------------------
	// MLinker method: removes adder
	//-----------------------------------------------------
	function atkMlRemoveAdder()
	{
		var items = document.getElementById(this.domId);
		var adder = document.getElementById(this.domId + 'Adder');
		items.removeChild(adder);
	}

	//-----------------------------------------------------
	// MLinker method: rebulds summary value
	//-----------------------------------------------------
	function atkMlRebuildValue()
	{
		var value = new String();
		for (i = 0; i < this.items.length; i++)
		{
			if ( i != 0 ) value += ",";
			value += this.items[i].value;
		}
		this.setValue(value);
	}


	//-----------------------------------------------------
	// atkLinkerPro object
	//-----------------------------------------------------
	
	//-----------------------------------------------------
	// atkLinkerPro (linkerpro) constructor
	//-----------------------------------------------------
	function atkLinkerPro(mode, field, trigger_textsize, trigger_timeout, selectorUrl, editorUrl, searcherUrl, config)
	{
		this.field = field;
		this.items = new Array();
		
		// mode can be 'single' or 'multiple'
		this.mode = mode;
		this.trigger_textsize = trigger_textsize;
		this.trigger_timeout = trigger_timeout;
		this.selectorUrl = selectorUrl;
		this.editorUrl = editorUrl;
		this.searcherUrl = searcherUrl;
		this.config = config;
		
		this.keyword = '';
		this.timeoutID = 0;
		this.more_link_visible = false;
		this.ajax = new sack();
		
		this.makeHTML = atkLProMakeHTML;
		this.makeFilterHTML = atkLProMakeFilterHTML;
		this.makeItem = atkLProMakeItem;
		this.makeFilterItem = atkLProMakeFilterItem;
		this.makeAdder = atkLProMakeAdder;
		this.makeFilterAdder = atkLProMakeFilterAdder;
		this.makeAdderControls = atkLProMakeAdderControls;
		this.makeAdderFilterControls = atkLProMakeAdderFilterControls;
		this.receive = atkLProReceive;
		this.receiveFilter = atkLProFilterReceive;
		this.appendItem = atkLProAppendItem;
		this.appendFilterItem = atkLProAppendFilterItem;
		this.appendMoreLink = atkLProAppendMoreLink;
		this.removeMoreLink = atkLProRemoveMoreLink;
		this.cleanDisabledItems = atkLProCleanDisabledItems;
		this.type=atkLProType;
		this.search=atkLProSearch;
		this.submit = atkLProSubmit;
		this.reset = atkLProReset;
		this.showMore = atkLProShowMore;
		
		// inherited from SLinker:
		this.showSelector = atkSlShowSelector;
		this.setValue = atkSlSetValue;  
		
		this.id = atkRegisterLinker(this);
		
		this.domId = "control" + this.id;
		this.divItemsId = this.domId + 'Items';
		this.divAdderControlsId = this.domId + 'AdderControls';
		this.divMoreLinkId = this.domId + 'MoreLink';
		this.txtKeywordId = this.domId + 'Keyword';
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for control 
	//-----------------------------------------------------
	function atkLProMakeHTML(targetDiv)
	{
		var code = '<div id="' + this.domId + '">\n'
			+ '<input type="hidden" name="'+ this.field + '" value="">\n'
			+ '<div id="' + this.divItemsId + '"></div>\n'
			+ '</div>\n'
			+ this.makeAdder() + '\n';
		
		if (targetDiv)
			targetDiv.innerHTML += code;
		else
			document.writeln(code);
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for an item view by its index
	//-----------------------------------------------------
	function atkLProMakeItem(i)
	{
		var type = this.mode == 'single' ? 'radio' : 'checkbox';
		try
		{
			var product = document.querySelector('input[name=ObjectID]').value;
		}
		catch(e)
		{
			console.log(e.name);
		}

		var extint = this.field == 'extints'
			? '<a href="#" onclick="showTagEditor('+this.items[i].value+','+product+'); return false;">Create/edit trigger</a>'
			: '';
		var title = this.editorUrl != ''
			? '<a target="_blank" href="' + this.editorUrl + this.items[i].value + '">' + this.items[i].title + '</a>'
			: this.items[i].title;
		
		return '<input type="' + type + '" name="'+ this.field +'" value="'+ this.items[i].value +'">'
			+ '&nbsp;' + title +'&nbsp;(#' + this.items[i].value  + ') ' + extint;
	}

	function showTagEditor(extint, product) 
	{
		var eurl = '#{THIS}/action/Jin/ExtInt/Persistent/tags?product=' + product + '&extint=' + extint;
		
		var wnd = window.open(eurl, 'Selector','menubar=no,resizable=yes,toolbar=no,location=no,scrollbars=yes,status=yes,width=750,height=550');
		wnd.focus();
		return false;
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for adder
	//-----------------------------------------------------
	function atkLProMakeAdder()
	{
		return '<input type="text" class="form-control" size=15 name="' + this.txtKeywordId + '" id="' + this.txtKeywordId + '" OnKeyUp="atkLinker('+ this.id +').type(this.value); return false;">'
			+ '<div id="' + this.divAdderControlsId + '">' + this.makeAdderControls() + '</div>';
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for adder controls
	//-----------------------------------------------------
	function atkLProMakeAdderControls()
	{
		return '<a href="#" onClick="atkLinker('+ this.id +').submit(); return false;" title="submit"><img src="#{THIS}/linkers_submit.gif" border="0" alt="submit"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').reset(); return false;" title="reset"><img src="#{THIS}/delete.png" border="0" alt="reset"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').showSelector(); return false;" title="select"><img src="#{THIS}/linkers_select.gif" border="0" alt="add"></a>';
	}

	//-----------------------------------------------------
	// LinkerPro method: alias for atkLProAppendItem
	//-----------------------------------------------------
	function atkLProReceive(value, title, setActive)
	{
		if (setActive == undefined)
			setActive = true;
		return this.appendItem(new atkItem(value, title), setActive);
	}

	//-----------------------------------------------------
	// LinkerPro method: appends item to the end of the items list and checks it
	//-----------------------------------------------------
	function atkLProAppendItem(item, setActive)
	{
		var pos = this.items.length;
		this.items.length++;
		this.items[pos] = item;
		
		var divItems = document.getElementById(this.divItemsId);
		var newItem = document.createElement("div");
		newItem.id = this.domId + 'Item' + pos;
		newItem.innerHTML = this.makeItem(pos);
		divItems.appendChild(newItem);
		
		var items = document.getElementsByName(this.field);
		if (this.type == 'single' && setActive)
			for (var i = 1; i < items.length; i++)
				items[i].checked = false;
		items[items.length - 1].checked = setActive;
	}

	//-----------------------------------------------------
	// LinkerPro method: appends '(N more...)' link to the end of the items list
	//-----------------------------------------------------
	function atkLProAppendMoreLink(N)
	{
		var divMain = document.getElementById(this.domId);
		var divMoreLink = document.createElement("div");
		divMoreLink.id = this.divMoreLinkId;
		divMoreLink.innerHTML = '(<a href="javascript:atkLinker(' + this.id + ').showMore();">show all' + ' ' + N + '</a>)';
		divMain.appendChild(divMoreLink);
		
		this.more_link_visible = true;
	}

	//-----------------------------------------------------
	// LinkerPro method: removes '(N more...)' link from the end of the items list
	//-----------------------------------------------------
	function atkLProRemoveMoreLink()
	{
		if (! this.more_link_visible)
			return;
		
		var divMain = document.getElementById(this.domId);
		var divMoreLink = document.getElementById(this.divMoreLinkId);
		divMain.removeChild(divMoreLink);
		
		this.more_link_visible = false;
	}

	//-----------------------------------------------------
	// LinkerPro method: removes disabled items from the items list
	//-----------------------------------------------------
	function atkLProCleanDisabledItems()
	{
		if (! this.items.length)
			return;
		
		var items = document.getElementsByName(this.field);
		
		var itemsQ = this.items.length;
		
		// remove disabled items
		for (var i = items.length - 1; i > 0; i--)
			if (! items[i].checked)
				this.items.splice(i - 1, 1);
		
		if (itemsQ == this.items.length)
			return;
		
		var divItems = document.getElementById(this.divItemsId);
		
		// clear divItems
		for (var i = items.length - 2; i >= 0; i--)
			divItems.removeChild(document.getElementById(this.domId + 'Item' + i));
		
		// recreate enabled items with new div' ID
		for (var i = 0; i < this.items.length; i++)
		{
			var newItem = document.createElement("div");
			newItem.id = this.domId + 'Item' + i;
			newItem.innerHTML = this.makeItem(i);
			divItems.appendChild(newItem);
		}
		
		// check recreated items
		var items = document.getElementsByName(this.field);
		for (var i = 1; i < items.length; i++)
			items[i].checked = true;
	}

	//-----------------------------------------------------
	// LinkerPro method: runs auto search by keyword after timeout
	//-----------------------------------------------------
	function atkLProType(keyword)
	{
		this.keyword = keyword;
		
		if (this.ajax == null || this.ajax.xmlhttp == null)
			this.ajax = new sack();
		
		if (this.ajax.xmlhttp.readyState && this.ajax.xmlhttp.readyState < 4)
		{
			this.ajax.xmlhttp.abort();
			this.ajax.reset();
			
			var divAdderControls = document.getElementById(this.divAdderControlsId);
			divAdderControls.innerHTML = this.makeAdderControls();
		}
		
		if (this.timeoutID)
			clearTimeout(this.timeoutID);
		
		if (keyword.length >= this.trigger_textsize)
			this.timeoutID = setTimeout("atkLProSearch(" + this.id + ");", this.trigger_timeout);
	}

	//-----------------------------------------------------
	// LinkerPro method: searches objects by keyword
	//-----------------------------------------------------
	function atkLProSearch(id)
	{
		var obj = atkLinker(id);
		
		// Configure ajax
		
		var ajax = obj.ajax;
		ajax.method = 'POST';
		ajax.requestFile = obj.searcherUrl;
		
		ajax.setVar('keyword', obj.keyword);
		ajax.setVar('linkerpro_id', obj.id);
		ajax.setVar('config', obj.config);
		
		// Specify function that will be executed after request complete
		
		ajax.onCompletion = 
			function()
			{
				obj.cleanDisabledItems();
				
				eval(ajax.response);
				
				var divAdderControls = document.getElementById(obj.divAdderControlsId);
				divAdderControls.innerHTML = obj.makeAdderControls();
				
				obj.ajax = new sack();
			};
		
		// POST data
		
		ajax.runAJAX();
		
		obj.removeMoreLink();
		document.getElementById(obj.divAdderControlsId).innerHTML = 'looking...';
	}

	//-----------------------------------------------------
	// LinkerPro method: resets all data
	//-----------------------------------------------------
	function atkLProReset()
	{
		if (this.mode == 'multiple' && this.items.length > 2)
			if (! confirm('Are you sure you want to reset all data?'))
				return;
		
		// clear divItems
		var divItems = document.getElementById(this.divItemsId);
		for (var i = 0; i < this.items.length; i++)
			divItems.removeChild(document.getElementById(this.domId + 'Item' + i));
		
		this.items.length = 0;
		
		this.removeMoreLink();
		
		if (this.timeoutID)
			clearTimeout(this.timeoutID);
		
		var txtKeyword = document.getElementById(this.txtKeywordId);
		txtKeyword.value = '';
		txtKeyword.focus();
	}

	//-----------------------------------------------------
	// LinkerPro method: starts search manually
	//-----------------------------------------------------
	function atkLProSubmit()
	{
		if (this.timeoutID)
			clearTimeout(this.timeoutID);
		
		if (this.keyword.length < this.trigger_textsize)
		{
			alert('The keyword you entered is too short. The least size of a keyword allowed is ' + this.trigger_textsize + '.');
			return;
		}
		
		this.search(this.id);
		
		document.getElementById(this.txtKeywordId).focus();
	}

	//-----------------------------------------------------
	// LinkerPro method: shows external selector window and fills sea_keyword field with keyword value
	//-----------------------------------------------------
	function atkLProShowMore()
	{
		//this.removeMoreLink();
		
		var eurl = this.selectorUrl;
		eurl += (eurl.indexOf('?') == -1) ? "?" : "&";
		eurl += 'js_receiver=' + this.id + '&sea_keyword=' + this.keyword;
		
		var wnd = window.open(eurl, 'Selector' + this.id,'menubar=no,resizable=yes,toolbar=no,location=no,scrollbars=yes,status=yes,width=750,height=550');
		wnd.focus();
	}


	//-----------------------------------------------------
	// Filter objects constructor
	//-----------------------------------------------------


	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for control 
	//-----------------------------------------------------
	function atkLProMakeFilterHTML(targetDiv)
	{
		var code = '<div id="' + this.domId + '">\n'
			+ '<input type="hidden" name="'+ this.field + '" value="">\n'
			+ '<div id="' + this.divItemsId + '"></div>\n'
			+ '</div>\n'
			+ this.makeFilterAdder() + '\n';
		
		if (targetDiv)
			targetDiv.innerHTML += code;
		else
			document.writeln(code);
	}


	//-----------------------------------------------------
	// atkItem object constructor. Item has value and title
	//-----------------------------------------------------
	function atkFilterItem(value, title, f_cond, parent, f_title)
	{
		this.value = value;
		this.title = title;
		this.f_cond = f_cond;
		this.f_title = f_title;
		this.parent = parent;
	}

	function atkLProMakeFilterItem(i)
	{
		var type = this.mode == 'single' ? 'radio' : 'checkbox';
		var title = this.editorUrl != ''
			? '<a target="_blank" href="' + this.editorUrl + this.items[i].value + '">' + this.items[i].title + '</a>' 
			: this.items[i].title;
		var f_cond = this.items[i].f_cond != '' ? this.items[i].f_cond + '__' : '';
		var addon = this.items[i].parent == 1 ? '<button class="btn btn-primary" onClick="atkLinker('+ this.id +').showSelector(\'' + f_cond + 'cond_and\',\'\',\'and\'); return false;">And</button>'
			+ '&nbsp;<button class="btn btn-primary" onClick="atkLinker('+ this.id +').showSelector(\'' + f_cond + 'cond_or\',\'\',\'or\'); return false;">Or</button>'
			+ '&nbsp;<button class="btn btn-primary" onClick="atkLinker('+ this.id +').showSelector(\'' + f_cond + 'cond_not\',\'\',\'not\'); return false;">Not</button>' : '';
		return '<b>' + this.items[i].f_title + '</b>'
			+ '<input class="form-control" type="' + type + '" name="' + f_cond + this.field + '" value="'+ this.items[i].value +'">'
			+ '&nbsp;' + title +'&nbsp;(#' + this.items[i].value  + ')'
			+ addon;
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for adder
	//-----------------------------------------------------
	function atkLProMakeFilterAdder()
	{
		return '<input type="text" class="form-control" size=15 name="' + this.txtKeywordId + '" id="' + this.txtKeywordId + '" OnKeyUp="atkLinker('+ this.id +').type(this.value); return false;">'
			+ '<div id="' + this.divAdderControlsId + '">' + this.makeAdderFilterControls() + '</div>';
	}

	//-----------------------------------------------------
	// LinkerPro method: returns HTML code for adder controls
	//-----------------------------------------------------
	function atkLProMakeAdderFilterControls()
	{
		return '<a href="#" onClick="atkLinker('+ this.id +').submit(); return false;" title="submit"><img src="#{THIS}/linkers_submit.gif" border="0" alt="submit"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').reset(); return false;" title="reset"><img src="#{THIS}/delete.png" border="0" alt="reset"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').showSelector(\'f_cond_and\', 1, \'AND\'); return false;" title="AND"><img src="#{THIS}/linkers_select.gif" border="0" alt="add"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').showSelector(\'f_cond_or\', 1, \'OR\'); return false;" title="OR"><img src="#{THIS}/linkers_select.gif" border="0" alt="add"></a>'
			+ '&nbsp;<a href="#" onClick="atkLinker('+ this.id +').showSelector(\'f_cond_not\', 1, \'NOT\'); return false;" title="NOT"><img src="#{THIS}/linkers_select.gif" border="0" alt="add"></a>';
	}

	//-----------------------------------------------------
	// LinkerPro method: alias for atkLProAppendItem
	//-----------------------------------------------------
	function atkLProFilterReceive(value, title, setActive, f_cond, parent, f_title)
	{
		if (setActive == undefined)
			setActive = true;
		return this.appendFilterItem(new atkFilterItem(value, title, f_cond, parent, f_title), setActive, f_cond);
	}


	///-----------------------------------------------------
	// LinkerPro method: appends item to the end of the items list and checks it
	//-----------------------------------------------------
	function atkLProAppendFilterItem(item, setActive, f_cond)
	{
		var pos = this.items.length;
		this.items.length++;
		this.items[pos] = item;
		
		var divItems = document.getElementById(this.divItemsId);
		var newItem = document.createElement("div");
		newItem.id = this.domId + 'Item' + pos;
		newItem.innerHTML = this.makeFilterItem(pos);
		divItems.appendChild(newItem);
		var items = document.getElementsByName(f_cond + "__" + this.field);
		if (this.type == 'single' && setActive)
			for (var i = 1; i < items.length; i++)
				items[i].checked = false;
		items[items.length - 1].checked = setActive;
	}
