/*
The library "Simple AJAX Code-Kit (SACK) v1.6.1" from module "/kit.zen/suppl/ajax/ajax.js" is used.
*/

function ajaxEditPacktable(ENV_SCRIPT_NAME, eid, action, str)
{
	// Create ajax
	
	var ajax = new sack();
	ajax.method = 'POST';
	ajax.requestFile = ENV_SCRIPT_NAME + '/action/Zen/Form/packedtable/edit.html';
	
	ajax.setVar('eid', eid);
	ajax.setVar('action', action);
	ajax.setVar('str', str);
	
	// packedtable data processing
	
	var TagName = new Array('input', 'textarea', 'select');
	
	for (t = 0; t < TagName.length; t++)
	{
		var elements = document.getElementsByTagName(TagName[t]);
		
		for (e = 0; e < elements.length; e++)
		{
			if (elements[e].name.indexOf(eid) != 0)
				continue;
			
			if (TagName[t] == 'input' 
				&& (elements[e].type == 'radio' || elements[e].type == 'checkbox')
				&& ! elements[e].checked
			)
				continue;
			
			if (TagName[t] == 'select' && elements[e].type == 'select-multiple')
			{
				var values = new Array();
				for (o = 0; o < elements[e].options.length; o++)
					if (elements[e].options[o].selected)
						values.push(elements[e].options[o].value);
				
				ajax.setVar(elements[e].name, values.join());
				continue;
			}
			
			if (ajax.vars[elements[e].name] == undefined)
			{
				ajax.setVar(elements[e].name, elements[e].value);
			}	
			else 
			{
				ajax.setVar(elements[e].name, ajax.vars[elements[e].name][0] + ',' + elements[e].value)
			}
		}
	}
	
	// Specify function that will be executed after request complete
	
	ajax.onCompletion = 
		function()
		{
			ajax_loadContent(eid, ENV_SCRIPT_NAME + '/action/Zen/Form/packedtable/show.html?eid=' + eid, function() { if (window.parent.adjustIFrameSize) window.parent.adjustIFrameSize(window.self.name); });
		};
	
	// POST data
	
	ajax.runAJAX();
}
